/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.infra.pgpVerifier;

import com.jetbrains.infra.pgpVerifier.PgpSignaturesVerifierLogger;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Provider;
import java.util.Iterator;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J&\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J\f\u0010!\u001a\u00020\f*\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/infra/pgpVerifier/PgpSignaturesVerifier;", "", "logger", "Lcom/jetbrains/infra/pgpVerifier/PgpSignaturesVerifierLogger;", "(Lcom/jetbrains/infra/pgpVerifier/PgpSignaturesVerifierLogger;)V", "bouncyCastleProvider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "assertPublicKeyFormat", "", "key", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "checkPublicKeyFormat", "", "checkSignatureFormat", "sig", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignaturesFromFile", "Lorg/bouncycastle/openpgp/PGPSignatureList;", "detachedSignatureInputStream", "Ljava/io/InputStream;", "getTrustedMasterKey", "trustedMasterKeyInputStream", "isRevoked", "", "subKey", "signature", "isSignKey", "isSubKeyForSigning", "masterKey", "verifySignature", "file", "Ljava/nio/file/Path;", "untrustedPublicKeyBundleInputStream", "toKeyIdString", "", "download-pgp-verifier"})
@SourceDebugExtension(value={"SMAP\nPgpSignaturesVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PgpSignaturesVerifier.kt\ncom/jetbrains/infra/pgpVerifier/PgpSignaturesVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class PgpSignaturesVerifier {
    @NotNull
    private final PgpSignaturesVerifierLogger logger;
    @NotNull
    private final BouncyCastleProvider bouncyCastleProvider;

    public PgpSignaturesVerifier(@NotNull PgpSignaturesVerifierLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.logger = logger2;
        this.bouncyCastleProvider = new BouncyCastleProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void verifySignature(@NotNull Path file, @NotNull InputStream detachedSignatureInputStream, @NotNull InputStream untrustedPublicKeyBundleInputStream, @NotNull InputStream trustedMasterKeyInputStream) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)detachedSignatureInputStream, (String)"detachedSignatureInputStream");
        Intrinsics.checkNotNullParameter((Object)untrustedPublicKeyBundleInputStream, (String)"untrustedPublicKeyBundleInputStream");
        Intrinsics.checkNotNullParameter((Object)trustedMasterKeyInputStream, (String)"trustedMasterKeyInputStream");
        PGPSignatureList signatures = this.getSignaturesFromFile(detachedSignatureInputStream);
        PGPPublicKeyRingCollection untrustedPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)untrustedPublicKeyBundleInputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        PGPPublicKey trustedMasterKey = this.getTrustedMasterKey(trustedMasterKeyInputStream);
        boolean verified = false;
        byte[] buf = new byte[16384];
        for (PGPSignature signature : signatures) {
            PGPPublicKey key;
            Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"signature");
            String signatureCheckError = this.checkSignatureFormat(signature);
            if (signatureCheckError != null) {
                this.logger.info("Signature skipped: " + signatureCheckError);
                continue;
            }
            if (untrustedPublicKeyRingCollection.getPublicKey(signature.getKeyID()) == null) continue;
            String keyCheckError = this.checkPublicKeyFormat(key);
            if (keyCheckError != null) {
                this.logger.info("Key skipped: " + keyCheckError);
                continue;
            }
            if (!this.isSubKeyForSigning(key, trustedMasterKey, this.logger)) continue;
            if (this.isRevoked(key, signature)) {
                this.logger.info("Key (ID:" + this.toKeyIdString(key.getKeyID()) + ") was revoked before signature timestamp");
                continue;
            }
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)this.bouncyCastleProvider), key);
            Closeable closeable = Files.newInputStream(file, new OpenOption[0]);
            Throwable throwable = null;
            try {
                int bytes;
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                while ((bytes = stream.read(buf)) >= 0) {
                    signature.update(buf, 0, bytes);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            if (!signature.verify()) {
                throw new IllegalStateException(("Signature verification failed for " + file).toString());
            }
            verified = true;
        }
        if (!verified) {
            throw new IllegalStateException(("No keys matched signature for " + file).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PGPPublicKey getTrustedMasterKey(InputStream trustedMasterKeyInputStream) {
        Closeable closeable = (Closeable)new BCPGInputStream((InputStream)new ArmoredInputStream(trustedMasterKeyInputStream));
        Throwable throwable = null;
        try {
            BCPGInputStream it = (BCPGInputStream)closeable;
            boolean bl = false;
            Packet packet = it.readPacket();
            Intrinsics.checkNotNull((Object)packet, (String)"null cannot be cast to non-null type org.bouncycastle.bcpg.PublicKeyPacket");
            PublicKeyPacket packet2 = (PublicKeyPacket)packet;
            byte[] rest = it.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)rest, (String)"rest");
            if (!(rest.length == 0)) {
                throw new IllegalStateException("Some leftovers in the stream after reading PublicKeyPacket".toString());
            }
            it = packet2;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        BCPGInputStream publicKeyPacket = it;
        PGPPublicKey trustedMasterKey = new PGPPublicKey((PublicKeyPacket)publicKeyPacket, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        if (!trustedMasterKey.isMasterKey()) {
            boolean bl = false;
            String string2 = "Key " + this.toKeyIdString(trustedMasterKey.getKeyID()) + " must be a master key";
            throw new IllegalArgumentException(string2.toString());
        }
        this.assertPublicKeyFormat(trustedMasterKey);
        return trustedMasterKey;
    }

    private final PGPSignatureList getSignaturesFromFile(InputStream detachedSignatureInputStream) {
        InputStream detachedSignatureDecoder = PGPUtil.getDecoderStream((InputStream)detachedSignatureInputStream);
        JcaPGPObjectFactory pgpFact = new JcaPGPObjectFactory(detachedSignatureDecoder);
        PGPSignatureList p3 = null;
        Object object = pgpFact.nextObject();
        if (object == null) {
            throw new IllegalStateException("PGP signature stream is empty".toString());
        }
        Object o = object;
        if (o instanceof PGPCompressedData) {
            PGPCompressedData c1 = (PGPCompressedData)o;
            pgpFact = new JcaPGPObjectFactory(c1.getDataStream());
            Object object2 = pgpFact.nextObject();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.bouncycastle.openpgp.PGPSignatureList");
            p3 = (PGPSignatureList)object2;
        } else {
            p3 = (PGPSignatureList)o;
        }
        return p3;
    }

    private final boolean isRevoked(PGPPublicKey subKey, PGPSignature signature) {
        Iterator iterator2 = subKey.getSignatures();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"subKey.signatures");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            PGPSignature revocationSignature = (PGPSignature)iterator3.next();
            if (revocationSignature.getSignatureType() != 40 || revocationSignature.getCreationTime().compareTo(signature.getCreationTime()) > 0) continue;
            return true;
        }
        return false;
    }

    private final boolean isSubKeyForSigning(PGPPublicKey subKey, PGPPublicKey masterKey, PgpSignaturesVerifierLogger logger2) {
        if (!masterKey.isMasterKey()) {
            boolean $i$a$-require-PgpSignaturesVerifier$isSubKeyForSigning$32 = false;
            String $i$a$-require-PgpSignaturesVerifier$isSubKeyForSigning$32 = "Key " + this.toKeyIdString(masterKey.getKeyID()) + " must be a master key";
            throw new IllegalArgumentException($i$a$-require-PgpSignaturesVerifier$isSubKeyForSigning$32.toString());
        }
        if (!(!subKey.isMasterKey())) {
            boolean $i$a$-require-PgpSignaturesVerifier$isSubKeyForSigning$42 = false;
            String $i$a$-require-PgpSignaturesVerifier$isSubKeyForSigning$42 = "Key " + this.toKeyIdString(subKey.getKeyID()) + " must be a sub key";
            throw new IllegalArgumentException($i$a$-require-PgpSignaturesVerifier$isSubKeyForSigning$42.toString());
        }
        Iterator iterator2 = subKey.getKeySignatures();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"subKey.keySignatures");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            PGPSignature signature = (PGPSignature)iterator3.next();
            if (signature == null || signature.getSignatureType() != 24 || signature.getKeyID() != masterKey.getKeyID() || !this.isSignKey(signature)) continue;
            String signatureCheckError = this.checkSignatureFormat(signature);
            if (signatureCheckError != null) {
                logger2.info("Signature for key '" + this.toKeyIdString(subKey.getKeyID()) + "' was skipped: " + signatureCheckError);
                continue;
            }
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider((Provider)this.bouncyCastleProvider), masterKey);
            if (!signature.verifyCertification(masterKey, subKey)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSignKey(PGPSignature sig) {
        return (sig.getHashedSubPackets().getKeyFlags() & 2) != 0;
    }

    private final String checkPublicKeyFormat(PGPPublicKey key) {
        if (key.getVersion() != 4) {
            return "Only PGP Public Keys version 4 are supported. Key ID = " + Long.toHexString(key.getKeyID());
        }
        if (key.getBitStrength() < 2048 || key.getBitStrength() > 100000) {
            return "Only PGP Public Keys bits >= 2048. Key ID = " + Long.toHexString(key.getKeyID());
        }
        return null;
    }

    private final void assertPublicKeyFormat(PGPPublicKey key) {
        String errorString = this.checkPublicKeyFormat(key);
        if (errorString != null) {
            throw new IllegalStateException(errorString.toString());
        }
    }

    private final String checkSignatureFormat(PGPSignature sig) {
        if (sig.getHashAlgorithm() != 8 && sig.getHashAlgorithm() != 9 && sig.getHashAlgorithm() != 10) {
            return "Only hashAlgorithms SHA256/384/512 are supported. See https://tools.ietf.org/html/rfc4880#section-9.4";
        }
        if (sig.getKeyAlgorithm() != 1) {
            return "Only keyAlgorithm = 1 (RSA (Encrypt or Sign)) is supported. See https://tools.ietf.org/html/rfc4880#section-9.1";
        }
        return null;
    }

    private final String toKeyIdString(long $this$toKeyIdString) {
        String string2 = Long.toHexString($this$toKeyIdString);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toHexString(this)");
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string3;
    }
}

