/*
 * Decompiled with CFR 0.152.
 */
package git4idea.diff;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsCommitMetadata;
import git4idea.GitUtil;
import git4idea.diff.GitDiffRevisionMetadataInProject;
import git4idea.history.GitLogUtil;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.util.CaffeineUtil;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0081\b\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lgit4idea/diff/GitDiffRevisionMetadataInProject;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "cache", "Lcom/github/benmanes/caffeine/cache/AsyncLoadingCache;", "Lgit4idea/diff/GitDiffRevisionMetadataInProject$CommitInRepo;", "Ljava/util/Optional;", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "get", "revision", "", "file", "Lcom/intellij/openapi/vcs/FilePath;", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/FilePath;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadMetadata", "commitInRepo", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "CommitInRepo", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitDiffRevisionMetadataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDiffRevisionMetadataProvider.kt\ngit4idea/diff/GitDiffRevisionMetadataInProject\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n23#2:61\n*S KotlinDebug\n*F\n+ 1 GitDiffRevisionMetadataProvider.kt\ngit4idea/diff/GitDiffRevisionMetadataInProject\n*L\n56#1:61\n*E\n"})
public final class GitDiffRevisionMetadataInProject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AsyncLoadingCache<CommitInRepo, Optional<VcsCommitMetadata>> cache;
    private static final Duration EXPIRE_IN = Duration.ofMinutes(1L);
    @NotNull
    private static final Logger LOG;

    public GitDiffRevisionMetadataInProject(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        AsyncLoadingCache asyncLoadingCache = CaffeineUtil.INSTANCE.withIoExecutor().expireAfterAccess(EXPIRE_IN).buildAsync(new AsyncCacheLoader(this){
            final /* synthetic */ GitDiffRevisionMetadataInProject this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableFuture<? extends Optional<VcsCommitMetadata>> asyncLoad(CommitInRepo key, Executor executor) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                return FutureKt.future$default((CoroutineScope)this.this$0.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Optional<VcsCommitMetadata>>, Object>(this.this$0, key, null){
                    int label;
                    final /* synthetic */ GitDiffRevisionMetadataInProject this$0;
                    final /* synthetic */ CommitInRepo $key;
                    {
                        this.this$0 = $receiver;
                        this.$key = $key;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                CommitInRepo commitInRepo = this.$key;
                                Intrinsics.checkNotNull((Object)commitInRepo);
                                return GitDiffRevisionMetadataInProject.access$loadMetadata(this.this$0, commitInRepo);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Optional<VcsCommitMetadata>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)asyncLoadingCache, (String)"buildAsync(...)");
        this.cache = asyncLoadingCache;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object get(@NotNull String revision, @NotNull FilePath file, @NotNull Continuation<? super VcsCommitMetadata> $completion) {
        if (!($completion instanceof get.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitDiffRevisionMetadataInProject this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.get(null, null, (Continuation<? super VcsCommitMetadata>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!GitUtil.isHashString(revision)) {
                    return null;
                }
                v0 = ProjectLevelVcsManager.Companion.getInstance(this.project).getVcsRootFor(file);
                if (v0 == null || (v0 = GitIndexVirtualFileKt.filePath(v0)) == null) {
                    return null;
                }
                root = v0;
                v1 = this.cache.get((Object)new CommitInRepo(revision, (FilePath)root));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"get(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)revision);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)root);
                $continuation.label = 1;
                v2 = FutureKt.await((CompletionStage)v1, (Continuation)$continuation);
                if (v2 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                root = (FilePath)$continuation.L$2;
                file = (FilePath)$continuation.L$1;
                revision = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl34:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"await(...)");
                return OptionalsKt.getOrNull((Optional)((Optional)v2));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Optional<VcsCommitMetadata> loadMetadata(CommitInRepo commitInRepo) {
        LOG.trace("Loading metadata for " + commitInRepo.getHash() + " in " + commitInRepo.getRepoRoot().getPath());
        VirtualFile virtualFile = commitInRepo.getRepoRoot().getVirtualFile();
        if (virtualFile == null) {
            Optional<VcsCommitMetadata> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        VirtualFile root = virtualFile;
        List<? extends VcsCommitMetadata> list = GitLogUtil.collectMetadata(this.project, root, CollectionsKt.listOf((Object)commitInRepo.getHash()));
        Intrinsics.checkNotNullExpressionValue(list, (String)"collectMetadata(...)");
        VcsCommitMetadata commitMetadata = (VcsCommitMetadata)CollectionsKt.singleOrNull(list);
        Optional<VcsCommitMetadata> optional = Optional.ofNullable(commitMetadata);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope component2() {
        return this.scope;
    }

    @NotNull
    public final GitDiffRevisionMetadataInProject copy(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new GitDiffRevisionMetadataInProject(project, scope);
    }

    public static /* synthetic */ GitDiffRevisionMetadataInProject copy$default(GitDiffRevisionMetadataInProject gitDiffRevisionMetadataInProject, Project project, CoroutineScope coroutineScope, int n, Object object) {
        if ((n & 1) != 0) {
            project = gitDiffRevisionMetadataInProject.project;
        }
        if ((n & 2) != 0) {
            coroutineScope = gitDiffRevisionMetadataInProject.scope;
        }
        return gitDiffRevisionMetadataInProject.copy(project, coroutineScope);
    }

    @NotNull
    public String toString() {
        return "GitDiffRevisionMetadataInProject(project=" + this.project + ", scope=" + this.scope + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.scope.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitDiffRevisionMetadataInProject)) {
            return false;
        }
        GitDiffRevisionMetadataInProject gitDiffRevisionMetadataInProject = (GitDiffRevisionMetadataInProject)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)gitDiffRevisionMetadataInProject.project)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scope, (Object)gitDiffRevisionMetadataInProject.scope);
    }

    public static final /* synthetic */ Optional access$loadMetadata(GitDiffRevisionMetadataInProject $this, CommitInRepo commitInRepo) {
        return $this.loadMetadata(commitInRepo);
    }

    static {
        Companion $this$thisLogger$iv = Companion;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lgit4idea/diff/GitDiffRevisionMetadataInProject$CommitInRepo;", "", "hash", "", "repoRoot", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/FilePath;)V", "getHash", "()Ljava/lang/String;", "getRepoRoot", "()Lcom/intellij/openapi/vcs/FilePath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class CommitInRepo {
        @NotNull
        private final String hash;
        @NotNull
        private final FilePath repoRoot;

        public CommitInRepo(@NotNull String hash, @NotNull FilePath repoRoot) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)repoRoot, (String)"repoRoot");
            this.hash = hash;
            this.repoRoot = repoRoot;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final FilePath getRepoRoot() {
            return this.repoRoot;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final FilePath component2() {
            return this.repoRoot;
        }

        @NotNull
        public final CommitInRepo copy(@NotNull String hash, @NotNull FilePath repoRoot) {
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)repoRoot, (String)"repoRoot");
            return new CommitInRepo(hash, repoRoot);
        }

        public static /* synthetic */ CommitInRepo copy$default(CommitInRepo commitInRepo, String string, FilePath filePath, int n, Object object) {
            if ((n & 1) != 0) {
                string = commitInRepo.hash;
            }
            if ((n & 2) != 0) {
                filePath = commitInRepo.repoRoot;
            }
            return commitInRepo.copy(string, filePath);
        }

        @NotNull
        public String toString() {
            return "CommitInRepo(hash=" + this.hash + ", repoRoot=" + this.repoRoot + ")";
        }

        public int hashCode() {
            int result2 = this.hash.hashCode();
            result2 = result2 * 31 + this.repoRoot.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommitInRepo)) {
                return false;
            }
            CommitInRepo commitInRepo = (CommitInRepo)other;
            if (!Intrinsics.areEqual((Object)this.hash, (Object)commitInRepo.hash)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.repoRoot, (Object)commitInRepo.repoRoot);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/diff/GitDiffRevisionMetadataInProject$Companion;", "", "<init>", "()V", "EXPIRE_IN", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lgit4idea/diff/GitDiffRevisionMetadataInProject;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitDiffRevisionMetadataInProject getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitDiffRevisionMetadataInProject.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitDiffRevisionMetadataInProject)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

