/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010H\u0004J \u0010\u0013\u001a\u00020\u00142\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0016j\b\u0012\u0004\u0012\u00020\u0003`\u0017H\u0004R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/performancePlugin/commands/AbstractFileCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "numberOfArguments", "<init>", "(Ljava/lang/String;II)V", "execute", "", "path", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "f", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "isCommandParametersRight", "", "input", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nAddFileCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddFileCommand.kt\ncom/jetbrains/performancePlugin/commands/AbstractFileCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1740#2,3:61\n*S KotlinDebug\n*F\n+ 1 AddFileCommand.kt\ncom/jetbrains/performancePlugin/commands/AbstractFileCommand\n*L\n30#1:61,3\n*E\n"})
public abstract class AbstractFileCommand
extends AbstractCallbackBasedCommand {
    private final int numberOfArguments;

    public AbstractFileCommand(@NotNull String text, int line, int numberOfArguments) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
        this.numberOfArguments = numberOfArguments;
    }

    public /* synthetic */ AbstractFileCommand(String string, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 4) != 0) {
            n2 = 2;
        }
        this(string, n, n2);
    }

    protected final void execute(@NotNull Path path, @NotNull ActionCallback callback2, @NotNull Function1<? super VirtualFile, ? extends Object> f) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(path);
        if (virtualFile == null) {
            callback2.reject("Directory or file by " + path + " path from parameters was not found.");
            return;
        }
        WriteAction.runAndWait(() -> AbstractFileCommand.execute$lambda$0(f, virtualFile));
        callback2.setDone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final boolean isCommandParametersRight(@NotNull ArrayList<String> input) {
        boolean bl;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (input.size() != this.numberOfArguments) return false;
        Iterable $this$all$iv = input;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
            Object element$iv = iterator2.next();
            String it = (String)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it, (Object)"")) return false;
            bl = true;
        } while (bl);
        return false;
    }

    private static final void execute$lambda$0(Function1 $f, VirtualFile $virtualFile) {
        $f.invoke((Object)$virtualFile);
    }
}

