/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer;

import ai.grazie.DataHolder;
import ai.grazie.text.Text;
import ai.grazie.text.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \t2\u00020\u0001:\u0002\b\tJ\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lai/grazie/nlp/tokenizer/Tokenizer;", "", "tokenize", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "text", "", "Lai/grazie/text/Text;", "Token", "Keys", "nlp-tokenizer"})
public interface Tokenizer {
    @NotNull
    public static final Keys Keys = ai.grazie.nlp.tokenizer.Tokenizer$Keys.$$INSTANCE;

    @NotNull
    default public List<Token> tokenize(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.tokenize(new Text(text2));
    }

    @NotNull
    default public List<Token> tokenize(@NotNull Text text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.tokenize(text2.getValue());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lai/grazie/nlp/tokenizer/Tokenizer$Keys;", "", "<init>", "()V", "sentences", "Lai/grazie/DataHolder$Key;", "", "Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "getSentences", "()Lai/grazie/DataHolder$Key;", "words", "getWords", "nlp-tokenizer"})
    public static final class Keys {
        static final /* synthetic */ Keys $$INSTANCE;
        @NotNull
        private static final DataHolder.Key<List<Token>> sentences;
        @NotNull
        private static final DataHolder.Key<List<Token>> words;

        private Keys() {
        }

        @NotNull
        public final DataHolder.Key<List<Token>> getSentences() {
            return sentences;
        }

        @NotNull
        public final DataHolder.Key<List<Token>> getWords() {
            return words;
        }

        static {
            $$INSTANCE = new Keys();
            sentences = new DataHolder.Key();
            words = new DataHolder.Key();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lai/grazie/nlp/tokenizer/Tokenizer$Token;", "", "text", "Lai/grazie/text/Text;", "interval", "Lai/grazie/text/TextRange;", "<init>", "(Lai/grazie/text/Text;Lai/grazie/text/TextRange;)V", "token", "", "range", "Lkotlin/ranges/IntRange;", "(Ljava/lang/String;Lkotlin/ranges/IntRange;)V", "getText", "()Lai/grazie/text/Text;", "getInterval", "()Lai/grazie/text/TextRange;", "getToken", "()Ljava/lang/String;", "getRange", "()Lkotlin/ranges/IntRange;", "merge", "other", "component1", "component2", "copy", "equals", "", "hashCode", "", "toString", "nlp-tokenizer"})
    public static final class Token {
        @NotNull
        private final Text text;
        @NotNull
        private final TextRange interval;

        public Token(@NotNull Text text2, @NotNull TextRange interval) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            this.text = text2;
            this.interval = interval;
        }

        @NotNull
        public final Text getText() {
            return this.text;
        }

        @NotNull
        public final TextRange getInterval() {
            return this.interval;
        }

        @NotNull
        public final String getToken() {
            return this.text.getValue();
        }

        @NotNull
        public final IntRange getRange() {
            return new IntRange(this.interval.getStart(), this.interval.getEndInclusive());
        }

        public Token(@NotNull String token, @NotNull IntRange range) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this(new Text(token), TextRange.Companion.invoke(range));
        }

        @NotNull
        public final Token merge(@NotNull Token other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(this.getRange().getEndInclusive() == other.getRange().getStart() - 1)) {
                boolean bl = false;
                String string = "Can't merge tokens which are not sequential. Ranges were [" + this.getRange().getStart() + ", " + this.getRange().getEndInclusive() + "] and [" + other.getRange().getStart() + ", " + other.getRange().getEndInclusive() + "].";
                throw new IllegalArgumentException(string.toString());
            }
            return new Token(this.getToken() + other.getToken(), new IntRange(this.getRange().getStart().intValue(), other.getRange().getEndInclusive().intValue()));
        }

        @NotNull
        public final Text component1() {
            return this.text;
        }

        @NotNull
        public final TextRange component2() {
            return this.interval;
        }

        @NotNull
        public final Token copy(@NotNull Text text2, @NotNull TextRange interval) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
            return new Token(text2, interval);
        }

        public static /* synthetic */ Token copy$default(Token token, Text text2, TextRange textRange, int n, Object object) {
            if ((n & 1) != 0) {
                text2 = token.text;
            }
            if ((n & 2) != 0) {
                textRange = token.interval;
            }
            return token.copy(text2, textRange);
        }

        @NotNull
        public String toString() {
            return "Token(text=" + this.text + ", interval=" + this.interval + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.interval.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)token.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.interval, (Object)token.interval);
        }
    }
}

