/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.vcs.shelf.RecentlyDeletedNode;
import com.intellij.vcs.shelf.ShelvedChangeNode;
import com.intellij.vcs.shelf.ShelvedListNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0014\u0010\u000f\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\"\u0010\u0010\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/shelf/ShelvedTreeModelBuilder;", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setShelvedLists", "", "shelvedLists", "", "Lcom/intellij/openapi/vcs/changes/shelf/ShelvedChangeList;", "setDeletedShelvedLists", "createShelvedListsWithChangesNode", "parentNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nShelvedTreeModelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShelvedTreeModelBuilder.kt\ncom/intellij/vcs/shelf/ShelvedTreeModelBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1563#2:62\n1634#2,3:63\n1869#2,2:66\n1563#2:68\n1634#2,3:69\n1869#2,2:72\n*S KotlinDebug\n*F\n+ 1 ShelvedTreeModelBuilder.kt\ncom/intellij/vcs/shelf/ShelvedTreeModelBuilder\n*L\n39#1:62\n39#1:63,3\n40#1:66,2\n41#1:68\n41#1:69,3\n42#1:72,2\n*E\n"})
public final class ShelvedTreeModelBuilder
extends TreeModelBuilder {
    @NotNull
    private final Project project;

    public ShelvedTreeModelBuilder(@NotNull Project project, @NotNull ChangesGroupingPolicyFactory grouping) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)grouping, (String)"grouping");
        super(project, grouping);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists2) {
        Intrinsics.checkNotNullParameter(shelvedLists2, (String)"shelvedLists");
        ChangesBrowserNode changesBrowserNode = this.myRoot;
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"myRoot");
        this.createShelvedListsWithChangesNode(shelvedLists2, changesBrowserNode);
    }

    public final void setDeletedShelvedLists(@NotNull List<ShelvedChangeList> shelvedLists2) {
        Intrinsics.checkNotNullParameter(shelvedLists2, (String)"shelvedLists");
        ChangesBrowserNode.TagImpl tag = new ChangesBrowserNode.TagImpl(VcsBundle.message((String)"shelve.recently.deleted.node", (Object[])new Object[0]));
        ChangesBrowserNode.Tag tag2 = (ChangesBrowserNode.Tag)tag;
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        ChangesBrowserNode changesBrowserNode = this.insertTagNode((ChangesBrowserNode)new RecentlyDeletedNode(tag2, simpleTextAttributes, true));
        Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"insertTagNode(...)");
        ChangesBrowserNode parentNode = changesBrowserNode;
        this.createShelvedListsWithChangesNode(shelvedLists2, parentNode);
    }

    /*
     * WARNING - void declaration
     */
    private final void createShelvedListsWithChangesNode(List<ShelvedChangeList> shelvedLists2, ChangesBrowserNode<?> parentNode) {
        for (ShelvedChangeList changeList : shelvedLists2) {
            void $this$forEach$iv;
            ShelvedBinaryFile it;
            Collection collection;
            Object item$iv$iv;
            Iterator $this$mapTo$iv$iv;
            List<ShelvedChange> changes;
            ShelvedListNode shelvedListNode = new ShelvedListNode(changeList);
            this.insertSubtreeRoot(shelvedListNode, parentNode);
            if (changeList.getChanges() == null) continue;
            List shelvedChanges = new ArrayList();
            Iterable $this$map$iv = changes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                ShelvedChange shelvedChange = (ShelvedChange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new ShelvedWrapper((ShelvedChange)((Object)it), changeList));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ShelvedWrapper it2 = (ShelvedWrapper)element$iv;
                boolean bl = false;
                shelvedChanges.add(it2);
            }
            List<ShelvedBinaryFile> list = changeList.getBinaryFiles();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBinaryFiles(...)");
            $this$map$iv = list;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator bl = $this$mapTo$iv$iv.iterator();
            while (bl.hasNext()) {
                item$iv$iv = bl.next();
                it = (ShelvedBinaryFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new ShelvedWrapper(it, changeList));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            $this$mapTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv;
                element$iv = $this$mapTo$iv$iv.next();
                ShelvedWrapper it3 = (ShelvedWrapper)element$iv;
                boolean bl3 = false;
                shelvedChanges.add(it3);
            }
            Comparator<Object> comparator = Comparator.comparing(arg_0 -> ShelvedTreeModelBuilder.createShelvedListsWithChangesNode$lambda$5(arg_0 -> ShelvedTreeModelBuilder.createShelvedListsWithChangesNode$lambda$4(this, arg_0), arg_0), TreeModelBuilder.CHANGE_COMPARATOR);
            Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
            CollectionsKt.sortWith((List)shelvedChanges, comparator);
            for (ShelvedWrapper shelved : shelvedChanges) {
                FilePath filePath;
                Change change = shelved.getChangeWithLocal(this.project);
                Intrinsics.checkNotNullExpressionValue((Object)ChangesUtil.getFilePath((Change)change), (String)"getFilePath(...)");
                this.insertChangeNode(change, shelvedListNode, new ShelvedChangeNode(shelved, filePath, change.getOriginText(this.project)));
            }
        }
    }

    private static final Change createShelvedListsWithChangesNode$lambda$4(ShelvedTreeModelBuilder this$0, ShelvedWrapper it) {
        return it.getChangeWithLocal(this$0.project);
    }

    private static final Change createShelvedListsWithChangesNode$lambda$5(Function1 $tmp0, Object p0) {
        return (Change)$tmp0.invoke(p0);
    }
}

