/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.history.ActivityId;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.history.LocalHistoryException;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchContext;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.PathsVerifier;
import com.intellij.openapi.diff.impl.patch.formove.TriggerAdditionOrDeletion;
import com.intellij.openapi.diff.impl.patch.formove.UndoApplyPatchDialog;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchUtil;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.VcsActivity;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PatchApplier {
    private static final Logger LOG = Logger.getInstance(PatchApplier.class);
    private final Project myProject;
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final List<FilePatch> myPatches;
    private final CommitContext myCommitContext;
    @Nullable
    private final LocalChangeList myTargetChangeList;
    @NotNull
    private final List<FilePatch> myRemainingPatches;
    @NotNull
    private final List<FilePatch> myFailedPatches;
    private final PathsVerifier myVerifier;
    private final boolean myReverseConflict;
    private final @NlsContexts.Label @Nullable String myLeftConflictPanelTitle;
    private final @NlsContexts.Label @Nullable String myRightConflictPanelTitle;
    private final @NlsContexts.Label @NotNull String myActivityName;
    @Nullable
    private final ActivityId myActivityId;

    @Contract(mutates="param3")
    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<FilePatch> patches, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext, boolean reverseConflict, @NlsContexts.Label @Nullable String leftConflictPanelTitle, @NlsContexts.Label @Nullable String rightConflictPanelTitle, @NlsContexts.Label @NotNull String activityName, @Nullable ActivityId activityId) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(0);
        }
        if (baseDirectory == null) {
            PatchApplier.$$$reportNull$$$0(1);
        }
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(2);
        }
        if (activityName == null) {
            PatchApplier.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myBaseDirectory = baseDirectory;
        this.myPatches = patches;
        this.myTargetChangeList = targetChangeList;
        this.myCommitContext = commitContext;
        this.myReverseConflict = reverseConflict;
        this.myLeftConflictPanelTitle = leftConflictPanelTitle;
        this.myRightConflictPanelTitle = rightConflictPanelTitle;
        this.myRemainingPatches = new ArrayList<FilePatch>();
        this.myFailedPatches = new ArrayList<FilePatch>();
        this.myVerifier = new PathsVerifier(this.myProject, baseDirectory, this.myPatches);
        this.myActivityName = activityName;
        this.myActivityId = activityId;
    }

    public void setIgnoreContentRootsCheck() {
        this.myVerifier.setIgnoreContentRootsCheck(true);
    }

    @Contract(mutates="param3")
    public PatchApplier(@NotNull Project project, @NotNull VirtualFile baseDirectory, @NotNull List<FilePatch> patches, @Nullable LocalChangeList targetChangeList, @Nullable CommitContext commitContext) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(4);
        }
        if (baseDirectory == null) {
            PatchApplier.$$$reportNull$$$0(5);
        }
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(6);
        }
        this(project, baseDirectory, patches, targetChangeList, commitContext, false, null, null, VcsBundle.message((String)"activity.name.apply.patch", (Object[])new Object[0]), VcsActivity.ApplyPatch);
    }

    @NotNull
    public List<FilePatch> getRemainingPatches() {
        List<FilePatch> list = this.myRemainingPatches;
        if (list == null) {
            PatchApplier.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public Collection<FilePatch> getFailedPatches() {
        List<FilePatch> list = this.myFailedPatches;
        if (list == null) {
            PatchApplier.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<FilePatch> getBinaryPatches() {
        List list = ContainerUtil.mapNotNull(this.myVerifier.getBinaryPatches(), patchInfo -> patchInfo.getApplyPatch().getPatch());
        if (list == null) {
            PatchApplier.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void execute() {
        this.execute(true, false);
    }

    public ApplyPatchStatus execute(boolean showSuccessNotification, boolean silentAddDelete) {
        return PatchApplier.executePatchGroup(Collections.singletonList(this), this.myTargetChangeList, showSuccessNotification, silentAddDelete, this.myActivityName, this.myActivityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runWithDefaultConfirmations(@NotNull Project project, boolean resetConfirmations, @NotNull Runnable task) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(10);
        }
        if (task == null) {
            PatchApplier.$$$reportNull$$$0(11);
        }
        if (!resetConfirmations) {
            task.run();
        } else {
            ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
            VcsShowConfirmationOption addConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, null);
            VcsShowConfirmationOption deleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, null);
            VcsShowConfirmationOption.Value addConfirmationValue = addConfirmation.getValue();
            VcsShowConfirmationOption.Value deleteConfirmationValue = deleteConfirmation.getValue();
            addConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            deleteConfirmation.setValue(VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY);
            try {
                task.run();
            }
            finally {
                addConfirmation.setValue(addConfirmationValue);
                deleteConfirmation.setValue(deleteConfirmationValue);
            }
        }
    }

    public static ApplyPatchStatus executePatchGroup(Collection<PatchApplier> group, @Nullable LocalChangeList localChangeList) {
        return PatchApplier.executePatchGroup(group, localChangeList, true, false, VcsBundle.message((String)"activity.name.apply.patch", (Object[])new Object[0]), VcsActivity.ApplyPatch);
    }

    public static ApplyPatchStatus executePatchGroup(Collection<PatchApplier> group, @Nullable LocalChangeList localChangeList, @NlsContexts.Label @NotNull String activityName, @NotNull ActivityId activityId) {
        if (activityName == null) {
            PatchApplier.$$$reportNull$$$0(12);
        }
        if (activityId == null) {
            PatchApplier.$$$reportNull$$$0(13);
        }
        return PatchApplier.executePatchGroup(group, localChangeList, true, false, activityName, activityId);
    }

    private static ApplyPatchStatus executePatchGroup(@NotNull Collection<PatchApplier> group, @Nullable LocalChangeList targetChangeList, boolean showSuccessNotification, boolean silentAddDelete, @NlsContexts.Label @NotNull String activityName, @Nullable ActivityId activityId) {
        if (group == null) {
            PatchApplier.$$$reportNull$$$0(14);
        }
        if (activityName == null) {
            PatchApplier.$$$reportNull$$$0(15);
        }
        if (group.isEmpty()) {
            return ApplyPatchStatus.SUCCESS;
        }
        Project project = group.iterator().next().myProject;
        return (ApplyPatchStatus)((Object)PartialChangesUtil.computeUnderChangeListSync(project, targetChangeList, () -> {
            ApplyPatchStatus result2 = ApplyPatchStatus.SUCCESS;
            for (PatchApplier patchApplier : group) {
                result2 = ApplyPatchStatus.and(result2, patchApplier.nonWriteActionPreCheck());
            }
            Label beforeLabel = LocalHistory.getInstance().putSystemLabel(project, VcsBundle.message((String)"patch.apply.before.patch.label.text", (Object[])new Object[0]));
            TriggerAdditionOrDeletion trigger = new TriggerAdditionOrDeletion(project);
            Ref refStatus = new Ref((Object)result2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                LocalHistoryAction action = activityId != null ? LocalHistory.getInstance().startAction(activityName, activityId) : null;
                try {
                    PatchApplier.runWithDefaultConfirmations(project, silentAddDelete, () -> CommandProcessor.getInstance().executeCommand(project, () -> {
                        ArrayList<FilePath> toBeAdded = new ArrayList<FilePath>();
                        ArrayList<FilePath> toBeDeleted = new ArrayList<FilePath>();
                        for (PatchApplier applier : group) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)((Object)refStatus.get()))))), applier.createFiles()));
                            toBeAdded.addAll(applier.myVerifier.getToBeAdded());
                            toBeDeleted.addAll(applier.myVerifier.getToBeDeleted());
                        }
                        trigger.prepare(toBeAdded, toBeDeleted);
                        if (refStatus.get() == ApplyPatchStatus.SUCCESS) {
                            refStatus.set(null);
                        }
                        for (PatchApplier applier : group) {
                            refStatus.set((Object)ApplyPatchStatus.and((ApplyPatchStatus)((Object)((Object)((Object)((Object)((Object)refStatus.get()))))), applier.executeWritable()));
                            if (refStatus.get() != ApplyPatchStatus.ABORT) continue;
                            break;
                        }
                    }, VcsBundle.message((String)"patch.apply.command", (Object[])new Object[0]), null));
                }
                finally {
                    trigger.cleanup();
                    if (action != null) {
                        action.finish();
                    }
                }
            });
            result2 = (ApplyPatchStatus)((Object)((Object)refStatus.get()));
            result2 = result2 == null ? ApplyPatchStatus.FAILURE : result2;
            trigger.processIt();
            boolean rollback = false;
            if (result2 == ApplyPatchStatus.FAILURE) {
                rollback = PatchApplier.askToRollback(project, group);
            }
            if (result2 == ApplyPatchStatus.ABORT || rollback) {
                PatchApplier.rollbackUnderProgressIfNeeded(project, beforeLabel);
            }
            if (showSuccessNotification || !ApplyPatchStatus.SUCCESS.equals((Object)result2)) {
                PatchApplier.showApplyStatus(project, result2);
            }
            HashSet<FilePath> directlyAffected = new HashSet<FilePath>();
            HashSet<VirtualFile> indirectlyAffected = new HashSet<VirtualFile>();
            for (PatchApplier applier : group) {
                directlyAffected.addAll(applier.getDirectlyAffected());
                indirectlyAffected.addAll(applier.getIndirectlyAffected());
            }
            directlyAffected.addAll(trigger.getAffected());
            PatchApplier.refreshPassedFiles(project, directlyAffected, indirectlyAffected);
            return result2;
        }));
    }

    private static boolean askToRollback(@NotNull Project project, @NotNull Collection<PatchApplier> group) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(16);
        }
        if (group == null) {
            PatchApplier.$$$reportNull$$$0(17);
        }
        List allFailed = ContainerUtil.concat(group, PatchApplier::getFailedPatches);
        boolean shouldInformAboutBinaries = ContainerUtil.exists(group, applier -> !applier.getBinaryPatches().isEmpty());
        List filePaths = ContainerUtil.map((Collection)allFailed, filePatch -> VcsUtil.getFilePath((String)((String)ObjectUtils.chooseNotNull((Object)filePatch.getAfterName(), (Object)filePatch.getBeforeName())), (boolean)false));
        AtomicBoolean doRollback = new AtomicBoolean();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            UndoApplyPatchDialog undoApplyPatchDialog = new UndoApplyPatchDialog(project, filePaths, shouldInformAboutBinaries);
            doRollback.set(undoApplyPatchDialog.showAndGet());
        });
        return doRollback.get();
    }

    private static void rollbackUnderProgressIfNeeded(@NotNull Project project, @NotNull Label labelToRevert) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(18);
        }
        if (labelToRevert == null) {
            PatchApplier.$$$reportNull$$$0(19);
        }
        Runnable rollback = () -> {
            try {
                labelToRevert.revert(project, project.getBaseDir());
                VcsNotifier.getInstance(project).notifyImportantWarning("vcs.patch.apply.aborted", VcsBundle.message((String)"patch.apply.aborted.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.aborted.message", (Object[])new Object[0]));
            }
            catch (LocalHistoryException e) {
                VcsNotifier.getInstance(project).notifyImportantWarning("vcs.patch.apply.rollback.failed", VcsBundle.message((String)"patch.apply.rollback.failed.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.rollback.failed.message", (Object[])new Object[0]));
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(rollback, VcsBundle.message((String)"patch.apply.rollback.progress.title", (Object[])new Object[0]), true, project);
        } else {
            ProgressManager.progress((String)VcsBundle.message((String)"patch.apply.rollback.progress", (Object[])new Object[0]));
            rollback.run();
        }
    }

    @NotNull
    private ApplyPatchStatus nonWriteActionPreCheck() {
        List<FilePatch> failedPreCheck = this.myVerifier.nonWriteActionPreCheck();
        List<FilePatch> skipped = this.myVerifier.getSkipped();
        this.myRemainingPatches.addAll(this.myPatches);
        this.myFailedPatches.addAll(failedPreCheck);
        this.myPatches.removeAll(failedPreCheck);
        this.myPatches.removeAll(skipped);
        if (!failedPreCheck.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.FAILURE;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(20);
            }
            return applyPatchStatus;
        }
        if (skipped.isEmpty()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(21);
            }
            return applyPatchStatus;
        }
        if (skipped.size() == this.myPatches.size()) {
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.ALREADY_APPLIED;
            if (applyPatchStatus == null) {
                PatchApplier.$$$reportNull$$$0(22);
            }
            return applyPatchStatus;
        }
        ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.PARTIAL;
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(23);
        }
        return applyPatchStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ApplyPatchStatus executeWritable() {
        ApplyPatchStatus applyStatus;
        block11: {
            AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-305053, EA-659443");
            ReadonlyStatusHandler.OperationStatus readOnlyFilesStatus = ReadonlyStatusHandler.getInstance((Project)this.myProject).ensureFilesWritable(this.myVerifier.getWritableFiles());
            if (!readOnlyFilesStatus.hasReadonlyFiles()) break block11;
            PatchApplier.showError(this.myProject, readOnlyFilesStatus.getReadonlyFilesMessage());
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.ABORT;
            ApplyPatchStatus applyPatchStatus2 = applyPatchStatus;
            if (applyPatchStatus2 == null) {
                PatchApplier.$$$reportNull$$$0(24);
            }
            return applyPatchStatus2;
            finally {
                if (ignore != null) {
                    ignore.close();
                }
            }
        }
        this.myFailedPatches.addAll(this.myVerifier.filterBadFileTypePatches());
        ApplyPatchStatus initStatus = this.myFailedPatches.isEmpty() ? null : ApplyPatchStatus.FAILURE;
        List<PathsVerifier.PatchAndFile> textPatches = this.myVerifier.getTextPatches();
        List<PathsVerifier.PatchAndFile> binaryPatches = this.myVerifier.getBinaryPatches();
        try {
            PatchApplier.markInternalOperation(textPatches, true);
            applyStatus = this.actualApply(ContainerUtil.concat(textPatches, binaryPatches), this.myCommitContext);
        }
        finally {
            PatchApplier.markInternalOperation(textPatches, false);
        }
        ApplyPatchStatus status = ApplyPatchStatus.and(initStatus, applyStatus);
        ApplyPatchStatus applyPatchStatus = (ApplyPatchStatus)((Object)ObjectUtils.notNull((Object)((Object)status), (Object)((Object)ApplyPatchStatus.SUCCESS)));
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(25);
        }
        return applyPatchStatus;
    }

    @NotNull
    private ApplyPatchStatus createFiles() {
        Boolean isSuccess = (Boolean)ApplicationManager.getApplication().runWriteAction(() -> {
            List<FilePatch> filePatches = this.myVerifier.execute();
            this.myFailedPatches.addAll(filePatches);
            this.myPatches.removeAll(filePatches);
            return this.myFailedPatches.isEmpty();
        });
        ApplyPatchStatus applyPatchStatus = isSuccess != false ? ApplyPatchStatus.SUCCESS : ApplyPatchStatus.FAILURE;
        if (applyPatchStatus == null) {
            PatchApplier.$$$reportNull$$$0(26);
        }
        return applyPatchStatus;
    }

    private static void markInternalOperation(List<PathsVerifier.PatchAndFile> textPatches, boolean set) {
        for (PathsVerifier.PatchAndFile patch : textPatches) {
            ChangesUtil.markInternalOperation((VirtualFile)patch.getFile(), (boolean)set);
        }
    }

    private List<FilePath> getDirectlyAffected() {
        return this.myVerifier.getDirectlyAffected();
    }

    private List<VirtualFile> getIndirectlyAffected() {
        return this.myVerifier.getAllAffected();
    }

    private static void refreshPassedFiles(@NotNull Project project, @NotNull Collection<? extends FilePath> directlyAffected, @NotNull Collection<? extends VirtualFile> indirectlyAffected) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(27);
        }
        if (directlyAffected == null) {
            PatchApplier.$$$reportNull$$$0(28);
        }
        if (indirectlyAffected == null) {
            PatchApplier.$$$reportNull$$$0(29);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (FilePath filePath : directlyAffected) {
            lfs.refreshAndFindFileByIoFile(filePath.getIOFile());
        }
        if (project.isDisposed()) {
            return;
        }
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        vcsDirtyScopeManager.filePathsDirty(directlyAffected, null);
        vcsDirtyScopeManager.filesDirty(indirectlyAffected, null);
    }

    @Nullable
    private ApplyPatchStatus actualApply(@NotNull List<PathsVerifier.PatchAndFile> patches, @Nullable CommitContext commitContext) {
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(30);
        }
        ApplyPatchContext context = new ApplyPatchContext(this.myBaseDirectory, 0, true, true);
        try {
            return this.applyList(patches, context, commitContext);
        }
        catch (IOException e) {
            PatchApplier.showError(this.myProject, e.getMessage());
            return ApplyPatchStatus.ABORT;
        }
    }

    @Nullable
    private ApplyPatchStatus applyList(@NotNull List<PathsVerifier.PatchAndFile> patches, @NotNull ApplyPatchContext context, @Nullable CommitContext commitContext) throws IOException {
        if (patches == null) {
            PatchApplier.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PatchApplier.$$$reportNull$$$0(32);
        }
        ApplyPatchStatus status = null;
        for (PathsVerifier.PatchAndFile patch : patches) {
            ApplyFilePatchBase<?> applyFilePatch = patch.getApplyPatch();
            ApplyPatchStatus patchStatus = ApplyPatchUtil.applyContent(this.myProject, applyFilePatch, context, patch.getFile(), commitContext, this.myReverseConflict, this.myLeftConflictPanelTitle, this.myRightConflictPanelTitle);
            if (patchStatus == ApplyPatchStatus.SUCCESS || patchStatus == ApplyPatchStatus.ALREADY_APPLIED) {
                PatchApplier.applyAdditionalPatchData(patch.getFile(), applyFilePatch.getPatch());
            }
            if (patchStatus == ApplyPatchStatus.ABORT) {
                return patchStatus;
            }
            status = ApplyPatchStatus.and(status, patchStatus);
            if (patchStatus == ApplyPatchStatus.FAILURE) {
                this.myFailedPatches.add((FilePatch)applyFilePatch.getPatch());
                continue;
            }
            if (patchStatus == ApplyPatchStatus.SKIP) continue;
            this.myVerifier.doMoveIfNeeded(patch.getFile());
            this.myRemainingPatches.remove(applyFilePatch.getPatch());
        }
        return status;
    }

    private static <V extends FilePatch> void applyAdditionalPatchData(@NotNull VirtualFile fileToApplyData, @NotNull V filePatch) {
        if (fileToApplyData == null) {
            PatchApplier.$$$reportNull$$$0(33);
        }
        if (filePatch == null) {
            PatchApplier.$$$reportNull$$$0(34);
        }
        int newFileMode = filePatch.getNewFileMode();
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)fileToApplyData);
        if (newFileMode == 100755 || newFileMode == 100644) {
            try {
                file.setExecutable(newFileMode == 100755);
            }
            catch (Exception e) {
                LOG.warn("Can't change file mode for " + fileToApplyData.getPresentableName());
            }
        }
    }

    private static void showApplyStatus(@NotNull Project project, ApplyPatchStatus status) {
        if (project == null) {
            PatchApplier.$$$reportNull$$$0(35);
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance(project);
        if (status == ApplyPatchStatus.ALREADY_APPLIED) {
            vcsNotifier.notifyMinorInfo("vcs.patch.already.applied", VcsBundle.message((String)"patch.apply.notification.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.already.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.PARTIAL) {
            vcsNotifier.notifyMinorInfo("vcs.patch.partially.applied", VcsBundle.message((String)"patch.apply.notification.title", (Object[])new Object[0]), VcsBundle.message((String)"patch.apply.partially.applied", (Object[])new Object[0]));
        } else if (status == ApplyPatchStatus.SUCCESS) {
            vcsNotifier.notifySuccess("vcs.patch.apply.success.applied", "", VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        }
    }

    public static void showError(Project project, @NlsContexts.DialogMessage String message) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VcsImplUtil.showErrorMessage(project, message, VcsBundle.message((String)"patch.apply.dialog.title", (Object[])new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 20, 21, 22, 23, 24, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirectory";
                break;
            }
            case 2: 
            case 6: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 3: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diff/impl/patch/formove/PatchApplier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityId";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelToRevert";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directlyAffected";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indirectlyAffected";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToApplyData";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diff/impl/patch/formove/PatchApplier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemainingPatches";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailedPatches";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryPatches";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "nonWriteActionPreCheck";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWritable";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runWithDefaultConfirmations";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "executePatchGroup";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "askToRollback";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "rollbackUnderProgressIfNeeded";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "refreshPassedFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "actualApply";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "applyList";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "applyAdditionalPatchData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "showApplyStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 20, 21, 22, 23, 24, 25, 26 -> new IllegalStateException(string);
        };
    }
}

