/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testing.base.plugins;

import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Incubating;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConsumableConfiguration;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.TestSuiteName;
import org.gradle.api.attributes.VerificationType;
import org.gradle.api.model.ObjectFactory;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;

@Incubating
public abstract class TestSuiteBasePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        TestingExtension testing = (TestingExtension)project.getExtensions().create("testing", TestingExtension.class, new Object[0]);
        testing.getSuites().configureEach(suite -> {
            NamedDomainObjectProvider<ConsumableConfiguration> testResultsVariant = TestSuiteBasePlugin.addTestResultsVariant(project, suite);
            suite.getTargets().configureEach(target -> testResultsVariant.configure(variant -> variant.getOutgoing().artifact(target.getBinaryResultsDirectory(), artifact -> artifact.setType("directory"))));
        });
    }

    private static NamedDomainObjectProvider<ConsumableConfiguration> addTestResultsVariant(Project project, TestSuite suite) {
        String variantName = String.format("testResultsElementsFor%s", StringUtils.capitalize((String)suite.getName()));
        return project.getConfigurations().consumable(variantName, conf -> {
            conf.setDescription("Binary results obtained from running all targets in the '" + suite.getName() + "' Test Suite.");
            ObjectFactory objects = project.getObjects();
            conf.attributes(attributes -> {
                attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objects.named(Category.class, "verification")));
                attributes.attribute(VerificationType.VERIFICATION_TYPE_ATTRIBUTE, (Object)((VerificationType)objects.named(VerificationType.class, "test-results")));
                attributes.attribute(TestSuiteName.TEST_SUITE_NAME_ATTRIBUTE, (Object)((TestSuiteName)objects.named(TestSuiteName.class, suite.getName())));
            });
        });
    }
}

