/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.Serializable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFilePermissions;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.internal.GUtil;
import org.gradle.work.DisableCachingByDefault;
import org.jspecify.annotations.Nullable;

@DisableCachingByDefault(because="Abstract super-class, not to be instantiated directly")
public abstract class AbstractArchiveTask
extends AbstractCopyTask {
    private static final String USE_FILE_SYSTEM_PERMISSIONS_PROPERTY = "org.gradle.archives.use-file-system-permissions";
    private final DirectoryProperty archiveDestinationDirectory;
    private final RegularFileProperty archiveFile;
    private final Property<String> archiveName;
    private final Property<String> archiveBaseName;
    private final Property<String> archiveAppendix;
    private final Property<String> archiveVersion;
    private final Property<String> archiveExtension;
    private final Property<String> archiveClassifier;
    private final Property<Boolean> archivePreserveFileTimestamps;
    private final Property<Boolean> archiveReproducibleFileOrder;

    public AbstractArchiveTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.archiveDestinationDirectory = objectFactory.directoryProperty();
        this.archiveBaseName = objectFactory.property(String.class);
        this.archiveAppendix = objectFactory.property(String.class);
        this.archiveVersion = objectFactory.property(String.class);
        this.archiveExtension = objectFactory.property(String.class);
        this.archiveClassifier = objectFactory.property(String.class).convention((Object)"");
        this.archiveName = objectFactory.property(String.class);
        this.archiveName.convention(this.getProject().provider(() -> {
            String name = (String)GUtil.elvis((Object)((String)this.archiveBaseName.getOrNull()), (Object)"");
            name = name + AbstractArchiveTask.maybe(name, (String)this.archiveAppendix.getOrNull());
            name = name + AbstractArchiveTask.maybe(name, (String)this.archiveVersion.getOrNull());
            name = name + AbstractArchiveTask.maybe(name, (String)this.archiveClassifier.getOrNull());
            String extension = (String)this.archiveExtension.getOrNull();
            name = name + (GUtil.isTrue((Object)extension) ? "." + extension : "");
            return name;
        }));
        this.archiveFile = objectFactory.fileProperty();
        this.archiveFile.convention(this.archiveDestinationDirectory.file(this.archiveName));
        this.archivePreserveFileTimestamps = objectFactory.property(Boolean.class).convention((Object)false);
        this.archiveReproducibleFileOrder = objectFactory.property(Boolean.class).convention((Object)true);
        this.configureDefaultPermissions();
    }

    private void configureDefaultPermissions() {
        ConfigurableFilePermissions defaultDirPermissions = this.getFileSystemOperations().permissions(493);
        ConfigurableFilePermissions defaultFilePermissions = this.getFileSystemOperations().permissions(420);
        this.getDirPermissions().convention((Object)defaultDirPermissions);
        this.getFilePermissions().convention((Object)defaultFilePermissions);
        Provider useFileSystemPermissions = this.getProject().getProviders().gradleProperty(USE_FILE_SYSTEM_PERMISSIONS_PROPERTY).map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)value -> Boolean.parseBoolean(value.trim()))).orElse((Object)false);
        this.getDirPermissions().set(useFileSystemPermissions.map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)fileSystemPermissions -> fileSystemPermissions != false ? null : defaultDirPermissions)));
        this.getFilePermissions().set(useFileSystemPermissions.map(SerializableLambdas.transformer((SerializableLambdas.SerializableTransformer & Serializable)fileSystemPermissions -> fileSystemPermissions != false ? null : defaultFilePermissions)));
    }

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    private static String maybe(@Nullable String prefix, @Nullable String value) {
        if (GUtil.isTrue((Object)value)) {
            if (GUtil.isTrue((Object)prefix)) {
                return "-".concat(value);
            }
            return value;
        }
        return "";
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveFileName() {
        return this.archiveName;
    }

    @OutputFile
    public Provider<RegularFile> getArchiveFile() {
        return this.archiveFile;
    }

    @Internal(value="Represented by the archiveFile")
    public DirectoryProperty getDestinationDirectory() {
        return this.archiveDestinationDirectory;
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveBaseName() {
        return this.archiveBaseName;
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveAppendix() {
        return this.archiveAppendix;
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveVersion() {
        return this.archiveVersion;
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveExtension() {
        return this.archiveExtension;
    }

    @Internal(value="Represented as part of archiveFile")
    public Property<String> getArchiveClassifier() {
        return this.archiveClassifier;
    }

    @Override
    public AbstractArchiveTask into(Object destPath) {
        super.into(destPath);
        return this;
    }

    @Override
    public AbstractArchiveTask into(Object destPath, Closure configureClosure) {
        super.into(destPath, configureClosure);
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        super.into(destPath, copySpec);
        return this;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isPreserveFileTimestamps() {
        return (Boolean)this.archivePreserveFileTimestamps.get();
    }

    public void setPreserveFileTimestamps(boolean preserveFileTimestamps) {
        this.archivePreserveFileTimestamps.set((Object)preserveFileTimestamps);
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isReproducibleFileOrder() {
        return (Boolean)this.archiveReproducibleFileOrder.get();
    }

    public void setReproducibleFileOrder(boolean reproducibleFileOrder) {
        this.archiveReproducibleFileOrder.set((Object)reproducibleFileOrder);
    }

    @Incubating
    public void useFileSystemPermissions() {
        this.getFilePermissions().set(this.getProject().getProviders().provider(() -> null));
        this.getDirPermissions().set(this.getProject().getProviders().provider(() -> null));
    }

    @Override
    protected CopyActionExecuter createCopyActionExecuter() {
        Instantiator instantiator = this.getInstantiator();
        FileSystem fileSystem = this.getFileSystem();
        return new CopyActionExecuter(instantiator, this.getPropertyFactory(), fileSystem, this.isReproducibleFileOrder(), this.getDocumentationRegistry());
    }
}

