/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultRootComponentIdentifier;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.VariantIdentityUniquenessVerifier;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalVariantGraphResolveStateBuilder;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.DefaultLocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.DefaultLocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveStateFactory;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildTree.class})
public class LocalComponentGraphResolveStateFactory {
    private final AttributeDesugaring attributeDesugaring;
    private final ComponentIdGenerator idGenerator;
    private final LocalVariantGraphResolveStateBuilder metadataBuilder;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    public LocalComponentGraphResolveStateFactory(AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator, LocalVariantGraphResolveStateBuilder metadataBuilder, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.attributeDesugaring = attributeDesugaring;
        this.idGenerator = idGenerator;
        this.metadataBuilder = metadataBuilder;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    public LocalComponentGraphResolveState realizedStateFor(LocalComponentGraphResolveMetadata metadata, List<? extends LocalVariantGraphResolveState> variants) {
        RealizedListVariantFactory configurationFactory = new RealizedListVariantFactory(variants);
        return this.createLocalComponentState(false, this.idGenerator.nextComponentId(), metadata, configurationFactory);
    }

    public LocalVariantGraphResolveState realizedVariantStateFor(LocalVariantGraphResolveMetadata metadata, DefaultLocalVariantGraphResolveState.VariantDependencyMetadata dependencyMetadata, Set<LocalVariantMetadata> variants) {
        CalculatedValueContainer calculatedDependencies = this.calculatedValueContainerFactory.create(Describables.of((Object)metadata, (Object)"dependencies"), context -> dependencyMetadata);
        return new DefaultLocalVariantGraphResolveState(this.idGenerator.nextVariantId(), metadata, (CalculatedValue<DefaultLocalVariantGraphResolveState.VariantDependencyMetadata>)calculatedDependencies, variants);
    }

    public LocalComponentGraphResolveState stateFor(ModelContainer<?> model, LocalComponentGraphResolveMetadata metadata, ConfigurationsProvider configurations) {
        ConfigurationsProviderVariantFactory variantsFactory = new ConfigurationsProviderVariantFactory(metadata.getId(), configurations, this.metadataBuilder, model, this.calculatedValueContainerFactory);
        return this.createLocalComponentState(false, this.idGenerator.nextComponentId(), metadata, variantsFactory);
    }

    public LocalComponentGraphResolveState adhocRootComponentState(String status, ModuleVersionIdentifier moduleVersionId, ImmutableAttributesSchema attributesSchema) {
        long instanceId = this.idGenerator.nextComponentId();
        DefaultRootComponentIdentifier componentIdentifier = new DefaultRootComponentIdentifier(instanceId);
        LocalComponentGraphResolveMetadata metadata = new LocalComponentGraphResolveMetadata(moduleVersionId, (ComponentIdentifier)componentIdentifier, status, attributesSchema);
        RealizedListVariantFactory configurationFactory = new RealizedListVariantFactory(Collections.emptyList());
        return this.createLocalComponentState(true, instanceId, metadata, configurationFactory);
    }

    private DefaultLocalComponentGraphResolveState createLocalComponentState(boolean adHoc, long instanceId, LocalComponentGraphResolveMetadata metadata, LocalVariantGraphResolveStateFactory variantsFactory) {
        return new DefaultLocalComponentGraphResolveState(instanceId, metadata, this.attributeDesugaring, adHoc, variantsFactory, this.calculatedValueContainerFactory);
    }

    private static class RealizedListVariantFactory
    implements LocalVariantGraphResolveStateFactory {
        private final List<? extends LocalVariantGraphResolveState> variants;

        public RealizedListVariantFactory(List<? extends LocalVariantGraphResolveState> variants) {
            this.variants = variants;
        }

        @Override
        public void visitConsumableVariants(Consumer<LocalVariantGraphResolveState> visitor) {
            for (LocalVariantGraphResolveState localVariantGraphResolveState : this.variants) {
                visitor.accept(localVariantGraphResolveState);
            }
        }
    }

    private static class ConfigurationsProviderVariantFactory
    implements LocalVariantGraphResolveStateFactory {
        private final ComponentIdentifier componentId;
        private final ConfigurationsProvider configurationsProvider;
        private final LocalVariantGraphResolveStateBuilder stateBuilder;
        private final ModelContainer<?> model;
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;

        public ConfigurationsProviderVariantFactory(ComponentIdentifier componentId, ConfigurationsProvider configurationsProvider, LocalVariantGraphResolveStateBuilder stateBuilder, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.componentId = componentId;
            this.configurationsProvider = configurationsProvider;
            this.stateBuilder = stateBuilder;
            this.model = model;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        @Override
        public void visitConsumableVariants(Consumer<LocalVariantGraphResolveState> visitor) {
            this.model.applyToMutableState(p -> {
                LocalVariantGraphResolveStateBuilder.DependencyCache cache = new LocalVariantGraphResolveStateBuilder.DependencyCache();
                VariantIdentityUniquenessVerifier.buildReport(this.configurationsProvider).assertNoConflicts();
                this.configurationsProvider.visitConsumable(configuration -> {
                    LocalVariantGraphResolveState variantState = this.stateBuilder.createConsumableVariantState((ConfigurationInternal)configuration, this.componentId, cache, this.model, this.calculatedValueContainerFactory);
                    visitor.accept(variantState);
                });
            });
        }
    }
}

