/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.component.model.VariantIdentifier;

public class NamedVariantIdentifier
implements VariantIdentifier {
    private final ComponentIdentifier componentIdentifier;
    private final String name;
    private final int hashCode;

    public NamedVariantIdentifier(ComponentIdentifier componentIdentifier, String name) {
        this.componentIdentifier = componentIdentifier;
        this.name = name;
        this.hashCode = NamedVariantIdentifier.computeHashCode(componentIdentifier, name);
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.componentIdentifier;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return this.name + "(" + this.componentIdentifier.getDisplayName() + ")";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedVariantIdentifier that = (NamedVariantIdentifier)o;
        return this.componentIdentifier.equals(that.componentIdentifier) && this.name.equals(that.name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int computeHashCode(ComponentIdentifier componentIdentifier, String name) {
        int result = componentIdentifier.hashCode();
        result = 31 * result + name.hashCode();
        return result;
    }
}

