/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.initialization.BuildEventConsumer;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.StreamedValue;

public class StreamedValueConsumer
implements BuildEventConsumer {
    private final ProviderOperationParameters providerParameters;
    private final PayloadSerializer payloadSerializer;
    private final BuildEventConsumer delegate;

    public StreamedValueConsumer(ProviderOperationParameters providerParameters, PayloadSerializer payloadSerializer, BuildEventConsumer delegate) {
        this.providerParameters = providerParameters;
        this.payloadSerializer = payloadSerializer;
        this.delegate = delegate;
    }

    public void dispatch(Object message) {
        if (message instanceof StreamedValue) {
            StreamedValue value = (StreamedValue)message;
            Object deserializedValue = this.payloadSerializer.deserialize(value.getSerializedModel());
            this.providerParameters.onStreamedValue(deserializedValue);
        } else {
            this.delegate.dispatch(message);
        }
    }
}

