/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.storage;

import java.io.IOException;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.io.PagedFileStorage;
import org.jetbrains.kotlin.com.intellij.util.io.storage.IRecordsTable;

public abstract class AbstractRecordsTable
implements IRecordsTable {
    private static final Logger LOG = Logger.getInstance(AbstractRecordsTable.class);
    protected final PagedFileStorage myStorage;
    private boolean myIsDirty;

    private int getSafelyClosedMagic() {
        return 523190100 + this.getImplVersion();
    }

    protected abstract int getImplVersion();

    @Override
    public void close() throws IOException {
        this.markClean();
        this.myStorage.close();
    }

    @Override
    public void force() throws IOException {
        this.markClean();
        this.myStorage.force();
    }

    @Override
    public boolean isDirty() {
        return this.myIsDirty || this.myStorage.isDirty();
    }

    private void markClean() throws IOException {
        if (this.myIsDirty) {
            this.myIsDirty = false;
            this.myStorage.putInt(0L, this.getSafelyClosedMagic());
        }
    }
}

