/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import tim.prune.function.srtm.SrtmAuthException;
import tim.prune.function.srtm.SrtmTile;

public abstract class SrtmSource {
    private final String _diskPath;
    public static final int VOID_VAL = Short.MIN_VALUE;

    SrtmSource(String string) {
        this._diskPath = string;
    }

    public abstract URL getUrl(SrtmTile var1);

    public abstract Result downloadTile(SrtmTile var1) throws SrtmAuthException;

    public abstract String getFilename(SrtmTile var1);

    public long getTileSizeBytes() {
        return (long)(this.getTilePixels() * this.getTilePixels()) * 2L;
    }

    public abstract int getTilePixels();

    public File getCacheDir() {
        if (this._diskPath == null) {
            return null;
        }
        return new File(this._diskPath, "srtm");
    }

    protected File getFileToWrite(URL uRL) {
        File file;
        File file2 = this.getCacheDir();
        if (file2 != null && file2.exists() && file2.isDirectory() && file2.canRead() && (!(file = new File(file2, new File(uRL.getFile()).getName())).exists() || !file.canRead() || file.length() <= 400L)) {
            return file;
        }
        return null;
    }

    protected boolean writeFileFromStream(URL uRL, InputStream inputStream) {
        block15: {
            if (inputStream == null) {
                return false;
            }
            File file = this.getFileToWrite(uRL);
            if (file == null) {
                return false;
            }
            byte[] byArray = new byte[512];
            Throwable throwable = null;
            Object var7_8 = null;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                int n;
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
                if (fileOutputStream == null) break block15;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    System.err.println(String.valueOf(iOException.getClass().getName()) + " - " + iOException.getMessage());
                    return false;
                }
            }
            fileOutputStream.close();
        }
        return true;
    }

    public static enum Result {
        DOWNLOADED,
        NOTHING_TO_DO,
        DOWNLOAD_FAILED,
        CACHE_FAILED,
        NOT_ENABLED;

    }
}

