/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.image.rendered.LRUCache;
import io.sf.carte.echosvg.ext.awt.image.rendered.TileGenerator;
import io.sf.carte.echosvg.ext.awt.image.rendered.TileLRUMember;
import io.sf.carte.echosvg.ext.awt.image.rendered.TileStore;
import io.sf.carte.echosvg.util.CleanerThread;
import io.sf.carte.echosvg.util.HaltingThread;
import java.awt.Point;
import java.awt.image.Raster;
import java.lang.ref.SoftReference;
import java.util.HashMap;

public class TileMap
implements TileStore {
    private static final boolean DEBUG = false;
    private static final boolean COUNT = false;
    private HashMap<Point, TileMapLRUMember> rasters = new HashMap();
    private TileGenerator source = null;
    private LRUCache cache = null;
    static int requests;
    static int misses;

    public TileMap(TileGenerator source, LRUCache cache) {
        this.cache = cache;
        this.source = source;
    }

    @Override
    public void setTile(int x, int y, Raster ras) {
        TileMapLRUMember item;
        Point pt = new Point(x, y);
        if (ras == null) {
            TileMapLRUMember o = this.rasters.remove(pt);
            if (o != null) {
                this.cache.remove(o);
            }
            return;
        }
        TileMapLRUMember o = this.rasters.get(pt);
        if (o == null) {
            item = new TileMapLRUMember(this, pt, ras);
            this.rasters.put(pt, item);
        } else {
            item = o;
            item.setRaster(ras);
        }
        this.cache.add(item);
    }

    @Override
    public Raster getTileNoCompute(int x, int y) {
        Point pt = new Point(x, y);
        TileMapLRUMember o = this.rasters.get(pt);
        if (o == null) {
            return null;
        }
        TileMapLRUMember item = o;
        Raster ret = item.retrieveRaster();
        if (ret != null) {
            this.cache.add(item);
        }
        return ret;
    }

    @Override
    public Raster getTile(int x, int y) {
        Raster ras = null;
        Point pt = new Point(x, y);
        TileMapLRUMember o = this.rasters.get(pt);
        TileMapLRUMember item = null;
        if (o != null) {
            item = o;
            ras = item.retrieveRaster();
        }
        if (ras == null) {
            ras = this.source.genTile(x, y);
            if (HaltingThread.hasBeenHalted()) {
                return ras;
            }
            if (item != null) {
                item.setRaster(ras);
            } else {
                item = new TileMapLRUMember(this, pt, ras);
                this.rasters.put(pt, item);
            }
        }
        this.cache.add(item);
        return ras;
    }

    static class TileMapLRUMember
    extends TileLRUMember {
        public Point pt;
        public SoftReference<TileMap> parent;

        TileMapLRUMember(TileMap parent, Point pt, Raster ras) {
            super(ras);
            this.parent = new SoftReference<TileMap>(parent);
            this.pt = pt;
        }

        @Override
        public void setRaster(Raster ras) {
            this.hRaster = ras;
            this.wRaster = new RasterSoftRef(ras);
        }

        class RasterSoftRef
        extends CleanerThread.SoftReferenceCleared<Raster> {
            RasterSoftRef(Raster o) {
                super((Object)o);
            }

            public void cleared() {
                TileMap tm = TileMapLRUMember.this.parent.get();
                if (tm != null) {
                    tm.rasters.remove(TileMapLRUMember.this.pt);
                }
            }
        }
    }
}

