/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNBrowseSettings;
import org.jkiss.dbeaver.model.secret.DBSSecretValue;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourcePageDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.BaseAuthDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageDeprecation;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageGeneral;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageInitialization;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageInternalParameters;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageSettings;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageShellCommands;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionDialog;
import org.jkiss.dbeaver.ui.preferences.PrefPageConnectionClient;
import org.jkiss.dbeaver.ui.preferences.PrefPageErrorHandle;
import org.jkiss.dbeaver.ui.preferences.PrefPageMetaData;
import org.jkiss.dbeaver.ui.preferences.PrefPageTransactions;
import org.jkiss.dbeaver.ui.preferences.WizardPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class EditConnectionWizard
extends ConnectionWizard {
    private static final Log log = Log.getLog(EditConnectionWizard.class);
    @NotNull
    private final DataSourceDescriptor originalDataSource;
    @NotNull
    private final DataSourceDescriptor dataSource;
    @NotNull
    private final Map<String, String> originalDriverLibsIdVersion;
    @Nullable
    private ConnectionPageSettings pageSettings;
    private ConnectionPageGeneral pageGeneral;
    private ConnectionPageInternalParameters pageInternalParameters;
    private ConnectionPageInitialization pageInit;
    private ConnectionPageShellCommands pageEvents;

    public EditConnectionWizard(@NotNull DataSourceDescriptor dataSource) {
        this.originalDataSource = dataSource;
        this.originalDriverLibsIdVersion = EditConnectionWizard.getLibsIdVersion(dataSource);
        this.dataSource = (DataSourceDescriptor)dataSource.getRegistry().createDataSource((DBPDataSourceContainer)dataSource);
        this.dataSource.setId(dataSource.getId());
        if (!this.dataSource.isSavePassword()) {
            this.dataSource.resetPassword();
        }
        this.setWindowTitle(CoreMessages.dialog_connection_wizard_title);
        this.setDriverSubstitution(dataSource.getDriverSubstitution());
        this.addPropertyChangeListener(event -> {
            if ("driver-substitution".equals(event.getProperty())) {
                ((Dialog)this.getContainer()).close();
                UIUtils.asyncExec(() -> {
                    boolean bl = EditConnectionDialog.openEditConnectionDialog(UIUtils.getActiveWorkbenchWindow(), (DBPDataSourceContainer)this.getOriginalDataSource(), null, wizard -> wizard.setDriverSubstitution((DBPDriverSubstitutionDescriptor)event.getNewValue()));
                });
            }
        });
    }

    @NotNull
    private static Map<String, String> getLibsIdVersion(@NotNull DataSourceDescriptor dataSource) {
        HashMap<String, String> libs = new HashMap<String, String>();
        for (DBPDriverLibrary lib : dataSource.getDriver().getDriverLibraries()) {
            if (lib.isDisabled()) continue;
            libs.put(lib.getId(), lib.getVersion());
        }
        return libs;
    }

    @Override
    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public DataSourceDescriptor getOriginalDataSource() {
        return this.originalDataSource;
    }

    @Override
    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.dataSource.getRegistry();
    }

    @Override
    public DBPDriver getSelectedDriver() {
        return this.dataSource.getDriver();
    }

    @Override
    DBPProject getSelectedProject() {
        return this.dataSource.getRegistry().getProject();
    }

    @Override
    DBNBrowseSettings getSelectedNavigatorSettings() {
        return this.dataSource.getNavigatorSettings();
    }

    @Override
    @Nullable
    public ConnectionPageSettings getPageSettings() {
        return this.pageSettings;
    }

    public void addPages() {
        if (this.dataSource.getDriver().isNotAvailable()) {
            this.addPage((IWizardPage)new ConnectionPageDeprecation(this.dataSource.getDriver()));
            return;
        }
        DataSourceViewDescriptor view = DataSourceViewRegistry.getInstance().findView(this.dataSource.getDriver().getProviderDescriptor(), "org.jkiss.dbeaver.ext.ui.editConnectionDialog");
        if (view != null) {
            this.pageSettings = new ConnectionPageSettings(this, view, this.getDriverSubstitution());
            this.addPage((IWizardPage)this.pageSettings);
        }
        boolean embedded = this.dataSource.getDriver().isEmbedded();
        this.pageGeneral = new ConnectionPageGeneral(this, this.dataSource);
        this.pageInternalParameters = new ConnectionPageInternalParameters(this.dataSource);
        this.pageInit = new ConnectionPageInitialization(this.dataSource);
        this.pageEvents = new ConnectionPageShellCommands(this.dataSource);
        this.addPage((IWizardPage)this.pageGeneral);
        if (this.pageSettings != null) {
            this.pageSettings.addSubPage((IDialogPage)this.pageInit);
            this.pageSettings.addSubPage((IDialogPage)this.pageEvents);
            if (!embedded) {
                this.pageSettings.addSubPage((IDialogPage)this.createPreferencePage((IPreferencePage)new PrefPageConnectionClient(), CoreMessages.dialog_connection_edit_wizard_connections, CoreMessages.dialog_connection_edit_wizard_connections_description));
            }
            this.pageSettings.addSubPage((IDialogPage)this.createPreferencePage((IPreferencePage)new PrefPageTransactions(), CoreMessages.dialog_connection_edit_wizard_transactions, CoreMessages.dialog_connection_edit_wizard_transactions_description));
            this.pageSettings.addSubPage((IDialogPage)this.pageInternalParameters);
        }
        this.addPreferencePage((IPreferencePage)new PrefPageMetaData(), CoreMessages.dialog_connection_edit_wizard_metadata, CoreMessages.dialog_connection_edit_wizard_metadata_description);
        this.addPreferencePage((IPreferencePage)new PrefPageErrorHandle(), CoreMessages.pref_page_error_handle_name, CoreMessages.pref_page_error_handle_description);
        for (DataSourcePageDescriptor page : DataSourceViewRegistry.getInstance().getRootDataSourcePages(this.dataSource)) {
            this.addDataSourcePage(null, page);
        }
    }

    private void addDataSourcePage(WizardPrefPage parent, DataSourcePageDescriptor page) {
        IPreferencePage pageInstance;
        try {
            pageInstance = page.createPage();
        }
        catch (Exception e) {
            log.error((Object)("Error instantiating connection preference page '" + page.getId() + "'"), (Throwable)e);
            return;
        }
        WizardPrefPage thisWizardPage = null;
        if (parent != null) {
            if (page.getTitle() != null) {
                thisWizardPage = parent.addSubPage(pageInstance, page.getTitle(), page.getDescription());
            } else {
                parent.addSubPage(page.getId(), pageInstance);
            }
        } else if (pageInstance instanceof IWizardPage) {
            this.addPage((IWizardPage)pageInstance);
        } else {
            thisWizardPage = this.addPreferencePage(pageInstance, page.getTitle(), page.getDescription());
        }
        if (thisWizardPage != null) {
            for (DataSourcePageDescriptor childPage : DataSourceViewRegistry.getInstance().getChildDataSourcePages((DBPDataSourceContainer)this.dataSource, page.getId())) {
                this.addDataSourcePage(thisWizardPage, childPage);
            }
        }
    }

    protected IAdaptable getActiveElement() {
        return this.dataSource;
    }

    public IWizardPage getPage(String name) {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDialogPage[] subPages;
            IWizardPage page = iWizardPageArray[n2];
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            if (page instanceof IDialogPageProvider && (subPages = ((IDialogPageProvider)page).getDialogPages(false, true)) != null) {
                IDialogPage[] iDialogPageArray = subPages;
                int n3 = subPages.length;
                int n4 = 0;
                while (n4 < n3) {
                    IDialogPage subPage = iDialogPageArray[n4];
                    if (subPage instanceof IWizardPage && ((IWizardPage)subPage).getName().equals(name)) {
                        return (IWizardPage)subPage;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    @NotNull
    protected ConnectionWizard.PersistResult persistDataSource() {
        if (this.dataSource.getDriver().isNotAvailable()) {
            return ConnectionWizard.PersistResult.UNCHANGED;
        }
        DBPDataSourceRegistry registry = this.originalDataSource.getRegistry();
        DataSourceDescriptor dsCopy = (DataSourceDescriptor)registry.createDataSource((DBPDataSourceContainer)this.originalDataSource);
        dsCopy.setId(this.originalDataSource.getId());
        DataSourceDescriptor dsChanged = (DataSourceDescriptor)this.dataSource.getRegistry().createDataSource((DBPDataSourceContainer)this.dataSource);
        dsChanged.setId(this.dataSource.getId());
        try {
            this.saveSettings(dsChanged);
            if (dsCopy.equalSettings((Object)dsChanged) && this.isDriverLibsVersionsSame(dsChanged)) {
                ConnectionWizard.PersistResult persistResult = ConnectionWizard.PersistResult.UNCHANGED;
                return persistResult;
            }
            if (!(CommonUtils.isEmpty((String)this.dataSource.getLockPasswordHash()) || this.isOnlyUserCredentialChanged(dsCopy, dsChanged) || this.checkLockPassword())) {
                ConnectionWizard.PersistResult persistResult = ConnectionWizard.PersistResult.ERROR;
                return persistResult;
            }
        }
        finally {
            dsCopy.dispose();
            dsChanged.dispose();
        }
        this.saveSettings(this.originalDataSource);
        DBSSecretValue selectedSharedCredentials = this.dataSource.getSelectedSharedCredentials();
        if (selectedSharedCredentials != null) {
            selectedSharedCredentials.setValue(this.originalDataSource.saveToSecret());
            this.originalDataSource.setSelectedSharedCredentials(selectedSharedCredentials);
        }
        if (this.originalDataSource.persistConfiguration()) {
            return ConnectionWizard.PersistResult.CHANGED;
        }
        return ConnectionWizard.PersistResult.ERROR;
    }

    private boolean isDriverLibsVersionsSame(@NotNull DataSourceDescriptor dsChangedSource) {
        Map<String, String> currentLibs = EditConnectionWizard.getLibsIdVersion(dsChangedSource);
        return this.originalDriverLibsIdVersion.equals(currentLibs);
    }

    public boolean performFinish() {
        ConnectionWizard.PersistResult result = this.persistDataSource();
        if (result == ConnectionWizard.PersistResult.CHANGED && this.originalDataSource.isConnected() && UIUtils.confirmAction((Shell)this.getShell(), (String)CoreMessages.dialog_connection_edit_wizard_conn_change_title, (String)NLS.bind((String)CoreMessages.dialog_connection_edit_wizard_conn_change_question, (Object)this.originalDataSource.getName()))) {
            DataSourceHandler.reconnectDataSource(null, (DBPDataSourceContainer)this.originalDataSource);
        }
        return result != ConnectionWizard.PersistResult.ERROR;
    }

    private boolean isOnlyUserCredentialChanged(DataSourceDescriptor dsCopy, DataSourceDescriptor dsChanged) {
        dsCopy.getConnectionConfiguration().setUserName(null);
        dsCopy.getConnectionConfiguration().setUserPassword(null);
        dsChanged.getConnectionConfiguration().setUserName(null);
        dsChanged.getConnectionConfiguration().setUserPassword(null);
        return dsCopy.equalSettings((Object)dsChanged);
    }

    private boolean checkLockPassword() {
        String userPassword;
        BaseAuthDialog dialog = new BaseAuthDialog(this.getShell(), CoreMessages.dialog_connection_edit_wizard_lock_pwd_title, true, false);
        if (dialog.open() == 0 && !CommonUtils.isEmpty((String)(userPassword = dialog.getUserPassword()))) {
            block4: {
                byte[] md5hash = MessageDigest.getInstance("MD5").digest(userPassword.getBytes(GeneralUtils.DEFAULT_ENCODING));
                String hexString = CommonUtils.toHexString((byte[])md5hash).toLowerCase(Locale.ENGLISH).trim();
                if (!hexString.equals(this.dataSource.getLockPasswordHash())) break block4;
                return true;
            }
            try {
                UIUtils.showMessageBox((Shell)this.getShell(), (String)CoreMessages.dialog_connection_edit_wizard_bad_pwd_title, (String)CoreMessages.dialog_connection_edit_wizard_bad_pwd_msg, (int)1);
            }
            catch (Throwable e) {
                DBWorkbench.getPlatformUI().showError(CoreMessages.dialog_connection_edit_wizard_error_md5_title, CoreMessages.dialog_connection_edit_wizard_error_md5_msg, e);
            }
        }
        return false;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    @Override
    protected void saveSettings(DataSourceDescriptor dataSource) {
        if (dataSource.getDriver().isNotAvailable()) {
            return;
        }
        if (EditConnectionWizard.isPageActive((IDialogPage)this.pageSettings)) {
            this.pageSettings.saveSettings(dataSource);
        }
        this.pageGeneral.saveSettings((DBPDataSourceContainer)dataSource);
        this.pageInternalParameters.saveSettings((DBPDataSourceContainer)dataSource);
        this.pageInit.saveSettings((DBPDataSourceContainer)dataSource);
        this.pageEvents.saveSettings((DBPDataSourceContainer)dataSource);
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            this.setPageDataSourceElement(dataSource, (IDialogPage)page);
            ++n2;
        }
        for (WizardPrefPage wpp : this.getPrefPages()) {
            this.setPageDataSourceElement(dataSource, (IDialogPage)wpp);
        }
        super.savePrefPageSettings();
        if (!dataSource.isSavePassword()) {
            dataSource.resetPassword();
        }
    }

    private void setPageDataSourceElement(DataSourceDescriptor dataSource, IDialogPage page) {
        IDialogPage[] subPages;
        if (page instanceof WizardPrefPage) {
            WizardPrefPage[] subPages2 = ((WizardPrefPage)page).getDialogPages(false, true);
            if (subPages2 != null) {
                WizardPrefPage[] wizardPrefPageArray = subPages2;
                int n = subPages2.length;
                int n2 = 0;
                while (n2 < n) {
                    WizardPrefPage dp = wizardPrefPageArray[n2];
                    this.setPageDataSourceElement(dataSource, (IDialogPage)dp);
                    ++n2;
                }
            }
            page = ((WizardPrefPage)page).getPreferencePage();
        } else if (page instanceof IDialogPageProvider && (subPages = ((IDialogPageProvider)page).getDialogPages(false, true)) != null) {
            IDialogPage[] iDialogPageArray = subPages;
            int n = subPages.length;
            int n3 = 0;
            while (n3 < n) {
                IDialogPage dp = iDialogPageArray[n3];
                this.setPageDataSourceElement(dataSource, dp);
                ++n3;
            }
        }
        if (page instanceof IWorkbenchPropertyPage) {
            ((IWorkbenchPropertyPage)page).setElement((IAdaptable)dataSource);
        }
    }

    private void savePageSettings(WizardPrefPage prefPage) {
        if (EditConnectionWizard.isPageActive((IDialogPage)prefPage)) {
            prefPage.performFinish();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.dataSource.dispose();
    }
}

