﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/model/WorkflowTypeInfo.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SWF {
namespace Model {
/**
 * <p>Contains a paginated list of information structures about workflow
 * types.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/WorkflowTypeInfos">AWS
 * API Reference</a></p>
 */
class ListWorkflowTypesResult {
 public:
  AWS_SWF_API ListWorkflowTypesResult() = default;
  AWS_SWF_API ListWorkflowTypesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SWF_API ListWorkflowTypesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of workflow type information.</p>
   */
  inline const Aws::Vector<WorkflowTypeInfo>& GetTypeInfos() const { return m_typeInfos; }
  template <typename TypeInfosT = Aws::Vector<WorkflowTypeInfo>>
  void SetTypeInfos(TypeInfosT&& value) {
    m_typeInfosHasBeenSet = true;
    m_typeInfos = std::forward<TypeInfosT>(value);
  }
  template <typename TypeInfosT = Aws::Vector<WorkflowTypeInfo>>
  ListWorkflowTypesResult& WithTypeInfos(TypeInfosT&& value) {
    SetTypeInfos(std::forward<TypeInfosT>(value));
    return *this;
  }
  template <typename TypeInfosT = WorkflowTypeInfo>
  ListWorkflowTypesResult& AddTypeInfos(TypeInfosT&& value) {
    m_typeInfosHasBeenSet = true;
    m_typeInfos.emplace_back(std::forward<TypeInfosT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If a <code>NextPageToken</code> was returned by a previous call, there are
   * more results available. To retrieve the next page of results, make the call
   * again using the returned token in <code>nextPageToken</code>. Keep all other
   * arguments unchanged.</p> <p>The configured <code>maximumPageSize</code>
   * determines how many results can be returned in a single call.</p>
   */
  inline const Aws::String& GetNextPageToken() const { return m_nextPageToken; }
  template <typename NextPageTokenT = Aws::String>
  void SetNextPageToken(NextPageTokenT&& value) {
    m_nextPageTokenHasBeenSet = true;
    m_nextPageToken = std::forward<NextPageTokenT>(value);
  }
  template <typename NextPageTokenT = Aws::String>
  ListWorkflowTypesResult& WithNextPageToken(NextPageTokenT&& value) {
    SetNextPageToken(std::forward<NextPageTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListWorkflowTypesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<WorkflowTypeInfo> m_typeInfos;

  Aws::String m_nextPageToken;

  Aws::String m_requestId;
  bool m_typeInfosHasBeenSet = false;
  bool m_nextPageTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
