﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/states/SFN_EXPORTS.h>
#include <aws/states/model/HistoryEventExecutionDataDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SFN {
namespace Model {

/**
 * <p>Contains details about the successful termination of the
 * execution.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/ExecutionSucceededEventDetails">AWS
 * API Reference</a></p>
 */
class ExecutionSucceededEventDetails {
 public:
  AWS_SFN_API ExecutionSucceededEventDetails() = default;
  AWS_SFN_API ExecutionSucceededEventDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SFN_API ExecutionSucceededEventDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SFN_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The JSON data output by the execution. Length constraints apply to the
   * payload size, and are expressed as bytes in UTF-8 encoding.</p>
   */
  inline const Aws::String& GetOutput() const { return m_output; }
  inline bool OutputHasBeenSet() const { return m_outputHasBeenSet; }
  template <typename OutputT = Aws::String>
  void SetOutput(OutputT&& value) {
    m_outputHasBeenSet = true;
    m_output = std::forward<OutputT>(value);
  }
  template <typename OutputT = Aws::String>
  ExecutionSucceededEventDetails& WithOutput(OutputT&& value) {
    SetOutput(std::forward<OutputT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Contains details about the output of an execution history event.</p>
   */
  inline const HistoryEventExecutionDataDetails& GetOutputDetails() const { return m_outputDetails; }
  inline bool OutputDetailsHasBeenSet() const { return m_outputDetailsHasBeenSet; }
  template <typename OutputDetailsT = HistoryEventExecutionDataDetails>
  void SetOutputDetails(OutputDetailsT&& value) {
    m_outputDetailsHasBeenSet = true;
    m_outputDetails = std::forward<OutputDetailsT>(value);
  }
  template <typename OutputDetailsT = HistoryEventExecutionDataDetails>
  ExecutionSucceededEventDetails& WithOutputDetails(OutputDetailsT&& value) {
    SetOutputDetails(std::forward<OutputDetailsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_output;

  HistoryEventExecutionDataDetails m_outputDetails;
  bool m_outputHasBeenSet = false;
  bool m_outputDetailsHasBeenSet = false;
};

}  // namespace Model
}  // namespace SFN
}  // namespace Aws
