﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/medialive/MediaLive_EXPORTS.h>
#include <aws/medialive/model/Output.h>
#include <aws/medialive/model/OutputGroupSettings.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaLive {
namespace Model {

/**
 * Output groups for this Live Event. Output groups contain information about where
 * streams should be distributed.<p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/OutputGroup">AWS
 * API Reference</a></p>
 */
class OutputGroup {
 public:
  AWS_MEDIALIVE_API OutputGroup() = default;
  AWS_MEDIALIVE_API OutputGroup(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API OutputGroup& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIALIVE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * Custom output group name optionally defined by the user.
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  OutputGroup& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * Settings associated with the output group.
   */
  inline const OutputGroupSettings& GetOutputGroupSettings() const { return m_outputGroupSettings; }
  inline bool OutputGroupSettingsHasBeenSet() const { return m_outputGroupSettingsHasBeenSet; }
  template <typename OutputGroupSettingsT = OutputGroupSettings>
  void SetOutputGroupSettings(OutputGroupSettingsT&& value) {
    m_outputGroupSettingsHasBeenSet = true;
    m_outputGroupSettings = std::forward<OutputGroupSettingsT>(value);
  }
  template <typename OutputGroupSettingsT = OutputGroupSettings>
  OutputGroup& WithOutputGroupSettings(OutputGroupSettingsT&& value) {
    SetOutputGroupSettings(std::forward<OutputGroupSettingsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Output>& GetOutputs() const { return m_outputs; }
  inline bool OutputsHasBeenSet() const { return m_outputsHasBeenSet; }
  template <typename OutputsT = Aws::Vector<Output>>
  void SetOutputs(OutputsT&& value) {
    m_outputsHasBeenSet = true;
    m_outputs = std::forward<OutputsT>(value);
  }
  template <typename OutputsT = Aws::Vector<Output>>
  OutputGroup& WithOutputs(OutputsT&& value) {
    SetOutputs(std::forward<OutputsT>(value));
    return *this;
  }
  template <typename OutputsT = Output>
  OutputGroup& AddOutputs(OutputsT&& value) {
    m_outputsHasBeenSet = true;
    m_outputs.emplace_back(std::forward<OutputsT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;

  OutputGroupSettings m_outputGroupSettings;

  Aws::Vector<Output> m_outputs;
  bool m_nameHasBeenSet = false;
  bool m_outputGroupSettingsHasBeenSet = false;
  bool m_outputsHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaLive
}  // namespace Aws
