/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.overrides;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.overrides.MemberWithOriginal;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/overrides/IrJavaIncompatibilityRulesOverridabilityCondition;", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "<init>", "()V", "isOverridable", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition$Result;", "superMember", "Lorg/jetbrains/kotlin/ir/overrides/MemberWithOriginal;", "subMember", "contract", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition$Contract;", "getContract", "()Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition$Contract;", "doesJavaOverrideHaveIncompatibleValueParameterKinds", "", "isJvmParameterTypePrimitive", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "index", "", "backend.jvm"})
@SourceDebugExtension(value={"SMAP\nIrJavaIncompatibilityRulesOverridabilityCondition.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrJavaIncompatibilityRulesOverridabilityCondition.kt\norg/jetbrains/kotlin/backend/jvm/overrides/IrJavaIncompatibilityRulesOverridabilityCondition\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1807#2,3:66\n*S KotlinDebug\n*F\n+ 1 IrJavaIncompatibilityRulesOverridabilityCondition.kt\norg/jetbrains/kotlin/backend/jvm/overrides/IrJavaIncompatibilityRulesOverridabilityCondition\n*L\n50#1:66,3\n*E\n"})
public final class IrJavaIncompatibilityRulesOverridabilityCondition
implements IrExternalOverridabilityCondition {
    @NotNull
    public IrExternalOverridabilityCondition.Result isOverridable(@NotNull MemberWithOriginal superMember, @NotNull MemberWithOriginal subMember) {
        Intrinsics.checkNotNullParameter((Object)superMember, (String)"superMember");
        Intrinsics.checkNotNullParameter((Object)subMember, (String)"subMember");
        if (this.doesJavaOverrideHaveIncompatibleValueParameterKinds(superMember, subMember)) {
            return IrExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return IrExternalOverridabilityCondition.Result.UNKNOWN;
    }

    @NotNull
    public IrExternalOverridabilityCondition.Contract getContract() {
        return IrExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    private final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(MemberWithOriginal superMember, MemberWithOriginal subMember) {
        boolean bl;
        block7: {
            IrOverridableMember irOverridableMember = superMember.getOriginal();
            IrSimpleFunction irSimpleFunction = irOverridableMember instanceof IrSimpleFunction ? (IrSimpleFunction)irOverridableMember : null;
            if (irSimpleFunction == null) {
                return false;
            }
            IrSimpleFunction originalSuperMember = irSimpleFunction;
            IrOverridableMember irOverridableMember2 = subMember.getOriginal();
            IrSimpleFunction irSimpleFunction2 = irOverridableMember2 instanceof IrSimpleFunction ? (IrSimpleFunction)irOverridableMember2 : null;
            if (irSimpleFunction2 == null) {
                return false;
            }
            IrSimpleFunction originalSubMember = irSimpleFunction2;
            IrValueParameter irValueParameter = originalSubMember.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            IrClass irClass = IrTypesKt.getClass((IrType)irValueParameter.getType());
            Intrinsics.checkNotNull((Object)irClass);
            if (!IrUtilsKt.isFromJava((IrDeclaration)((IrDeclaration)irClass))) {
                return false;
            }
            if (!(originalSubMember.getParameters().size() == originalSuperMember.getParameters().size())) {
                boolean $i$a$-require-IrJavaIncompatibilityRulesOverridabilityCondition$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = false;
                String $i$a$-require-IrJavaIncompatibilityRulesOverridabilityCondition$doesJavaOverrideHaveIncompatibleValueParameterKinds$22 = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size: subMember=" + RenderIrElementKt.render$default((IrElement)((IrElement)originalSubMember), null, (int)1, null) + " superMember=" + RenderIrElementKt.render$default((IrElement)((IrElement)originalSuperMember), null, (int)1, null);
                throw new IllegalArgumentException($i$a$-require-IrJavaIncompatibilityRulesOverridabilityCondition$doesJavaOverrideHaveIncompatibleValueParameterKinds$22.toString());
            }
            Iterable $this$any$iv = IrUtilsKt.getNonDispatchParameters((IrFunction)((IrFunction)originalSubMember));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter param = (IrValueParameter)element$iv;
                    boolean bl2 = false;
                    if (!(this.isJvmParameterTypePrimitive(originalSuperMember, param.getIndexInParameters()) != this.isJvmParameterTypePrimitive(originalSubMember, param.getIndexInParameters()))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isJvmParameterTypePrimitive(IrSimpleFunction function2, int index) {
        IrType type = ((IrValueParameter)function2.getParameters().get(index)).getType();
        return IrTypePredicatesKt.isPrimitiveType$default((IrType)type, (boolean)false, (int)1, null) && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)type), (ClassId)StandardClassIds.Annotations.INSTANCE.getFlexibleNullability()) && !IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)type), (ClassId)StandardClassIds.Annotations.INSTANCE.getEnhancedNullability()) && !MethodSignatureMapper.Companion.shouldBoxSingleValueParameterForSpecialCaseOfRemove((IrFunction)function2);
    }
}

