/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateFileType;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class TextMateTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            TextMateTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextMateTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TextMateTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            TextMateTypedHandler.$$$reportNull$$$0(3);
        }
        if (fileType == TextMateFileType.INSTANCE) {
            if (c == '\'' || c == '\"' || c == '`') {
                if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        TextMateTypedHandler.$$$reportNull$$$0(4);
                    }
                    return result;
                }
            } else if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    TextMateTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            int offset = editor.getCaretModel().getOffset();
            @Nullable TextMateScope scopeSelector = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
            Document document = editor.getDocument();
            TextMateAutoClosingPair pairForRightChar = TextMateTypedHandler.findSingleCharSmartTypingPair(c, scopeSelector);
            if (pairForRightChar != null && offset < document.getTextLength() && document.getCharsSequence().charAt(offset) == c) {
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    TextMateTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            TextMateTypedHandler.$$$reportNull$$$0(7);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            TextMateTypedHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            TextMateTypedHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            TextMateTypedHandler.$$$reportNull$$$0(10);
        }
        if (file.getFileType() == TextMateFileType.INSTANCE) {
            if (c == '\'' || c == '\"' || c == '`') {
                if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        TextMateTypedHandler.$$$reportNull$$$0(11);
                    }
                    return result;
                }
            } else if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    TextMateTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            int offset = editor.getCaretModel().getOffset();
            @Nullable TextMateScope scopeSelector = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
            CharSequence sequence = editor.getDocument().getCharsSequence();
            TextMateAutoClosingPair autoInsertingPair = TextMateTypedHandler.findAutoInsertingPair(offset, sequence, scopeSelector);
            if (autoInsertingPair != null) {
                int rightBraceEndOffset = offset + autoInsertingPair.getRight().length();
                if (rightBraceEndOffset < sequence.length() && StringUtil.equals((CharSequence)autoInsertingPair.getRight(), (CharSequence)sequence.subSequence(offset, rightBraceEndOffset))) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        TextMateTypedHandler.$$$reportNull$$$0(13);
                    }
                    return result;
                }
                if (StringUtil.equals((CharSequence)autoInsertingPair.getLeft(), (CharSequence)autoInsertingPair.getRight())) {
                    if (offset < sequence.length() && Character.isLetterOrDigit(sequence.charAt(offset))) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            TextMateTypedHandler.$$$reportNull$$$0(14);
                        }
                        return result;
                    }
                    int leftBraceStartOffset = offset - autoInsertingPair.getLeft().length();
                    if (leftBraceStartOffset > 0 && Character.isLetterOrDigit(sequence.charAt(leftBraceStartOffset - 1))) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            TextMateTypedHandler.$$$reportNull$$$0(15);
                        }
                        return result;
                    }
                }
                EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)autoInsertingPair.getRight().toString(), (boolean)true, (boolean)false);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    TextMateTypedHandler.$$$reportNull$$$0(16);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            TextMateTypedHandler.$$$reportNull$$$0(17);
        }
        return result;
    }

    private static TextMateAutoClosingPair findSingleCharSmartTypingPair(char closingChar, @Nullable TextMateScope currentSelector) {
        if (!TextMateService.getInstance().getPreferenceRegistry().isPossibleRightSmartTypingBrace(closingChar)) {
            return null;
        }
        Set<TextMateAutoClosingPair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentSelector);
        for (TextMateAutoClosingPair pair : pairs) {
            if (pair.getRight().length() != 1 || pair.getRight().charAt(0) != closingChar) continue;
            return pair;
        }
        return null;
    }

    public static TextMateAutoClosingPair findAutoInsertingPair(int offset, @NotNull CharSequence fileText, @Nullable TextMateScope currentScope) {
        if (fileText == null) {
            TextMateTypedHandler.$$$reportNull$$$0(18);
        }
        if (offset == 0 || !TextMateService.getInstance().getPreferenceRegistry().isPossibleLeftSmartTypingBrace(fileText.charAt(offset - 1))) {
            return null;
        }
        Set<TextMateAutoClosingPair> pairs = TextMateEditorUtils.getSmartTypingPairs(currentScope);
        for (TextMateAutoClosingPair pair : pairs) {
            int startOffset = offset - pair.getLeft().length();
            if (startOffset < 0 || !StringUtil.equals((CharSequence)pair.getLeft(), (CharSequence)fileText.subSequence(startOffset, offset))) continue;
            return pair;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/editor/TextMateTypedHandler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findAutoInsertingPair";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 11, 12, 13, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

