/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import org.assertj.core.presentation.NumberGrouping;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.util.Strings;

public class HexadecimalRepresentation
extends StandardRepresentation {
    public static final HexadecimalRepresentation HEXA_REPRESENTATION = new HexadecimalRepresentation();
    public static final String PREFIX = "0x";
    public static final int NIBBLE_SIZE = 4;

    @Override
    public String toStringOf(Object object) {
        if (this.hasCustomFormatterFor(object)) {
            return this.customFormat(object);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return this.toStringOf(number);
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.toStringOf(this, string);
        }
        if (object instanceof Character) {
            Character character = (Character)object;
            return this.toStringOf(character);
        }
        return super.toStringOf(object);
    }

    @Override
    protected String toStringOf(Number number) {
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return this.toStringOf(b);
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return this.toStringOf(s);
        }
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return this.toStringOf(i);
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            return this.toStringOf(l);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return this.toStringOf(f);
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return this.toStringOf(d);
        }
        return number.toString();
    }

    protected String toStringOf(Byte b) {
        return HexadecimalRepresentation.toGroupedHex(b, 8);
    }

    protected String toStringOf(Short s) {
        return HexadecimalRepresentation.toGroupedHex(s, 16);
    }

    protected String toStringOf(Integer i) {
        return HexadecimalRepresentation.toGroupedHex(i, 32);
    }

    @Override
    protected String toStringOf(Long l) {
        return HexadecimalRepresentation.toGroupedHex(l, 64);
    }

    @Override
    protected String toStringOf(Float f) {
        return HexadecimalRepresentation.toGroupedHex(Float.floatToIntBits(f.floatValue()), 32);
    }

    protected String toStringOf(Double d) {
        return HexadecimalRepresentation.toGroupedHex(Double.doubleToRawLongBits(d), 64);
    }

    @Override
    protected String toStringOf(Character character) {
        return Strings.concat("'", this.toStringOf((short)character.charValue()), "'");
    }

    protected String toStringOf(Representation representation, String s) {
        return Strings.concat("\"", representation.toStringOf(s.toCharArray()), "\"");
    }

    private static String toGroupedHex(Number value, int size) {
        return PREFIX + NumberGrouping.toHexLiteral(HexadecimalRepresentation.toHex(value, size));
    }

    private static String toHex(Number value, int sizeInBits) {
        return String.format("%0" + sizeInBits / 4 + "X", value);
    }
}

