/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.util.ThrowableConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataInputOutputUtil {
    public static final long timeBase = 1040688000000L;

    private DataInputOutputUtil() {
    }

    public static int readINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(0);
        }
        return DataInputOutputUtilRt.readINT((DataInput)record);
    }

    public static int readINT(@NotNull ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            DataInputOutputUtil.$$$reportNull$$$0(1);
        }
        return DataInputOutputUtilRt.readINT((ByteBuffer)byteBuffer);
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(2);
        }
        DataInputOutputUtilRt.writeINT((DataOutput)record, (int)val);
    }

    public static void writeINT(@NotNull ByteBuffer byteBuffer, int val) {
        if (byteBuffer == null) {
            DataInputOutputUtil.$$$reportNull$$$0(3);
        }
        DataInputOutputUtilRt.writeINT((ByteBuffer)byteBuffer, (int)val);
    }

    public static long readLONG(@NotNull DataInput record) throws IOException {
        int val;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(4);
        }
        if ((val = record.readUnsignedByte()) < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static long readLONG(@NotNull ByteBuffer record) throws IOException {
        int val;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(5);
        }
        if ((val = record.get() & 0xFF) < 192) {
            return val;
        }
        long res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.get() & 0xFF;
            res |= (long)(next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeLONG(@NotNull DataOutput record, long val) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(6);
        }
        if (0L > val || val >= 192L) {
            record.writeByte(192 + (int)(val & 0x3FL));
            val >>>= 6;
            while (val >= 128L) {
                record.writeByte((int)(val & 0x7FL) | 0x80);
                val >>>= 7;
            }
        }
        record.writeByte((int)val);
    }

    public static int readSINT(@NotNull DataInput record) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(7);
        }
        return DataInputOutputUtil.readINT(record) - 64;
    }

    public static void writeSINT(@NotNull DataOutput record, int val) throws IOException {
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(8);
        }
        DataInputOutputUtil.writeINT(record, val + 64);
    }

    public static void writeTIME(@NotNull DataOutput record, long timestamp) throws IOException {
        long relStamp;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(9);
        }
        if ((relStamp = timestamp - 1040688000000L) < 0L || relStamp >= 0xFF00000000L) {
            record.writeByte(255);
            record.writeLong(timestamp);
        } else {
            record.writeByte((int)(relStamp >> 32));
            record.writeByte((int)(relStamp >> 24));
            record.writeByte((int)(relStamp >> 16));
            record.writeByte((int)(relStamp >> 8));
            record.writeByte((int)relStamp);
        }
    }

    public static void writeTIME(@NotNull ByteBuffer buffer, long timestamp) {
        long relStamp;
        if (buffer == null) {
            DataInputOutputUtil.$$$reportNull$$$0(10);
        }
        if ((relStamp = timestamp - 1040688000000L) < 0L || relStamp >= 0xFF00000000L) {
            buffer.put((byte)-1);
            buffer.putLong(timestamp);
        } else {
            buffer.put((byte)(relStamp >> 32));
            buffer.put((byte)(relStamp >> 24));
            buffer.put((byte)(relStamp >> 16));
            buffer.put((byte)(relStamp >> 8));
            buffer.put((byte)relStamp);
        }
    }

    public static long readTIME(@NotNull DataInput record) throws IOException {
        int first2;
        if (record == null) {
            DataInputOutputUtil.$$$reportNull$$$0(11);
        }
        if ((first2 = record.readUnsignedByte()) == 255) {
            return record.readLong();
        }
        int second2 = record.readUnsignedByte();
        int third = record.readUnsignedByte() << 16;
        int fourth = record.readUnsignedByte() << 8;
        int fifth = record.readUnsignedByte();
        return ((long)(first2 << 8 | second2) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }

    public static long readTIME(@NotNull ByteBuffer buffer) {
        int first2;
        if (buffer == null) {
            DataInputOutputUtil.$$$reportNull$$$0(12);
        }
        if ((first2 = Byte.toUnsignedInt(buffer.get())) == 255) {
            return buffer.getLong();
        }
        int second2 = Byte.toUnsignedInt(buffer.get());
        int third = Byte.toUnsignedInt(buffer.get()) << 16;
        int fourth = Byte.toUnsignedInt(buffer.get()) << 8;
        int fifth = Byte.toUnsignedInt(buffer.get());
        return ((long)(first2 << 8 | second2) << 24 | (long)(third | fourth | fifth)) + 1040688000000L;
    }

    public static <T> void writeNullable(@NotNull DataOutput out, @Nullable T value, @NotNull ThrowableConsumer<? super T, ? extends IOException> writeValue) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(13);
        }
        if (writeValue == null) {
            DataInputOutputUtil.$$$reportNull$$$0(14);
        }
        out.writeBoolean(value != null);
        if (value != null) {
            writeValue.consume(value);
        }
    }

    @Nullable
    public static <T> T readNullable(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, ? extends IOException> readValue) throws IOException {
        if (in == null) {
            DataInputOutputUtil.$$$reportNull$$$0(15);
        }
        if (readValue == null) {
            DataInputOutputUtil.$$$reportNull$$$0(16);
        }
        return (T)(in.readBoolean() ? readValue.compute() : null);
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, IOException> readElement) throws IOException {
        if (in == null) {
            DataInputOutputUtil.$$$reportNull$$$0(17);
        }
        if (readElement == null) {
            DataInputOutputUtil.$$$reportNull$$$0(18);
        }
        List list = DataInputOutputUtilRt.readSeq((DataInput)in, readElement);
        if (list == null) {
            DataInputOutputUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<? extends T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(20);
        }
        if (collection == null) {
            DataInputOutputUtil.$$$reportNull$$$0(21);
        }
        if (writeElement == null) {
            DataInputOutputUtil.$$$reportNull$$$0(22);
        }
        DataInputOutputUtilRt.writeSeq((DataOutput)out, collection, writeElement);
    }

    @ApiStatus.Internal
    public static void writeDiffCompressed(@NotNull DataOutput out, int[] arrayPreferablySorted, int length) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(23);
        }
        DataInputOutputUtil.writeINT(out, length);
        int previousItem = 0;
        for (int i = 0; i < length; ++i) {
            int currentItem = arrayPreferablySorted[i];
            DataInputOutputUtil.writeLONG(out, (long)currentItem - (long)previousItem);
            previousItem = currentItem;
        }
    }

    @ApiStatus.Internal
    public static void writeDiffCompressed(@NotNull DataOutput out, @NotNull IntList dataPreferablySorted) throws IOException {
        if (out == null) {
            DataInputOutputUtil.$$$reportNull$$$0(24);
        }
        if (dataPreferablySorted == null) {
            DataInputOutputUtil.$$$reportNull$$$0(25);
        }
        int length = dataPreferablySorted.size();
        DataInputOutputUtil.writeINT(out, length);
        int previousItem = 0;
        for (int i = 0; i < length; ++i) {
            int currentItem = dataPreferablySorted.getInt(i);
            DataInputOutputUtil.writeLONG(out, (long)currentItem - (long)previousItem);
            previousItem = currentItem;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteBuffer";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 13: 
            case 20: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeValue";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readValue";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/DataInputOutputUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeElement";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPreferablySorted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/DataInputOutputUtil";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "readSeq";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readINT";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeINT";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readLONG";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeLONG";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readSINT";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeSINT";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeTIME";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readTIME";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeNullable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readNullable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readSeq";
                break;
            }
            case 19: {
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "writeSeq";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeDiffCompressed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

