/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class LowMemoryWatcher {
    private static final Logger LOG = Logger.getInstance(LowMemoryWatcher.class);
    private static final WeakList<LowMemoryWatcher> ourListeners = new WeakList();
    private final Runnable myRunnable;
    private final LowMemoryWatcherType myType;
    private static final AtomicBoolean ourNotificationsSuppressed = new AtomicBoolean();

    public static <T> T runWithNotificationsSuppressed(@NotNull Computable<T> runnable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(0);
        }
        if (ourNotificationsSuppressed.getAndSet(true)) {
            throw new IllegalStateException("runWithNotificationsSuppressed does not support reentrancy");
        }
        try {
            T t = runnable.compute();
            return t;
        }
        finally {
            ourNotificationsSuppressed.set(false);
        }
    }

    public static void onLowMemorySignalReceived(boolean memorySubsystemOverloaded) {
        if (LowMemoryWatcher.notificationsSuppressed()) {
            LOG.info("Low memory signal received (gc overloaded: " + memorySubsystemOverloaded + ") but suppressed");
            return;
        }
        LOG.info("Low memory signal received (gc overloaded: " + memorySubsystemOverloaded + ")");
        for (LowMemoryWatcher watcher : ourListeners.toStrongList()) {
            try {
                if (watcher.myType != LowMemoryWatcherType.ALWAYS && (watcher.myType != LowMemoryWatcherType.ONLY_AFTER_GC || !memorySubsystemOverloaded)) continue;
                watcher.myRunnable.run();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    static boolean notificationsSuppressed() {
        return ourNotificationsSuppressed.get();
    }

    @Contract(pure=true)
    public static LowMemoryWatcher register(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType notificationType) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(1);
        }
        if (notificationType == null) {
            LowMemoryWatcher.$$$reportNull$$$0(2);
        }
        return new LowMemoryWatcher(runnable, notificationType);
    }

    @Contract(pure=true)
    public static LowMemoryWatcher register(@NotNull Runnable runnable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(3);
        }
        return new LowMemoryWatcher(runnable, LowMemoryWatcherType.ALWAYS);
    }

    public static void register(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType notificationType, @NotNull Disposable parentDisposable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(4);
        }
        if (notificationType == null) {
            LowMemoryWatcher.$$$reportNull$$$0(5);
        }
        if (parentDisposable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(6);
        }
        LowMemoryWatcher watcher = new LowMemoryWatcher(runnable, notificationType);
        Disposer.register(parentDisposable, () -> watcher.stop());
    }

    public static void register(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(7);
        }
        if (parentDisposable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(8);
        }
        LowMemoryWatcher.register(runnable, LowMemoryWatcherType.ALWAYS, parentDisposable);
    }

    private LowMemoryWatcher(@NotNull Runnable runnable, @NotNull LowMemoryWatcherType type) {
        if (runnable == null) {
            LowMemoryWatcher.$$$reportNull$$$0(9);
        }
        if (type == null) {
            LowMemoryWatcher.$$$reportNull$$$0(10);
        }
        this.myRunnable = runnable;
        this.myType = type;
        ourListeners.add(this);
    }

    public void stop() {
        ourListeners.remove(this);
    }

    static void stopAll() {
        ourListeners.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/LowMemoryWatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithNotificationsSuppressed";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum LowMemoryWatcherType {
        ALWAYS,
        ONLY_AFTER_GC;

    }
}

