/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.UrlOpeningExpander;

public final class SelectLocationDialog
extends DialogWrapper {
    private final Project myProject;
    private RepositoryBrowserComponent myRepositoryBrowser;
    private final Url myURL;
    private final String myDstName;
    private final @NlsContexts.Label @Nullable String myDstLabel;
    private JTextField myDstText;
    private final boolean myIsShowFiles;
    private final boolean myAllowActions;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.common";

    @Nullable
    public static Url selectLocation(Project project, @NotNull Url url) {
        SelectLocationDialog dialog;
        if (url == null) {
            SelectLocationDialog.$$$reportNull$$$0(0);
        }
        return (dialog = SelectLocationDialog.openDialog(project, url, null, null, true, null)) == null || !dialog.isOK() ? null : dialog.getSelectedURL();
    }

    @Nullable
    public static Pair<Url, Url> selectLocationAndRoot(Project project, @NotNull Url url) {
        SelectLocationDialog dialog;
        if (url == null) {
            SelectLocationDialog.$$$reportNull$$$0(1);
        }
        return (dialog = new SelectLocationDialog(project, url, null, null, true, true)).showAndGet() ? Pair.create((Object)dialog.getSelectedURL(), (Object)dialog.getRootUrl()) : null;
    }

    @Nullable
    public static Url selectCopyDestination(@NotNull Project project, @NotNull Url url, @NotNull String dstName) throws SvnBindException {
        SelectLocationDialog dialog;
        if (project == null) {
            SelectLocationDialog.$$$reportNull$$$0(2);
        }
        if (url == null) {
            SelectLocationDialog.$$$reportNull$$$0(3);
        }
        if (dstName == null) {
            SelectLocationDialog.$$$reportNull$$$0(4);
        }
        return (dialog = SelectLocationDialog.openDialog(project, url, SvnBundle.message("label.copy.select.location.dialog.copy.as", new Object[0]), dstName, false, SvnBundle.message("select.location.invalid.url.message", url))) == null || !dialog.isOK() ? null : SvnUtil.append(Objects.requireNonNull(dialog.getSelectedURL()), dialog.getDestinationName());
    }

    @Nullable
    private static SelectLocationDialog openDialog(Project project, @NotNull Url url, @NlsContexts.Label @Nullable String dstLabel, String dstName, boolean showFiles, @NlsContexts.DialogMessage @Nullable String errorMessage) {
        if (url == null) {
            SelectLocationDialog.$$$reportNull$$$0(5);
        }
        try {
            Url repositoryUrl = SelectLocationDialog.initRoot(project, url);
            if (repositoryUrl == null) {
                Messages.showErrorDialog((Project)project, (String)SvnBundle.message("dialog.message.can.not.detect.repository.root.for.url", url), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
                return null;
            }
            SelectLocationDialog dialog = new SelectLocationDialog(project, repositoryUrl, dstLabel, dstName, showFiles, false);
            dialog.show();
            return dialog;
        }
        catch (SvnBindException e) {
            Messages.showErrorDialog((Project)project, (String)(errorMessage != null ? errorMessage : e.getMessage()), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
            return null;
        }
    }

    private SelectLocationDialog(Project project, Url url, @NlsContexts.Label @Nullable String dstLabel, String dstName, boolean showFiles, boolean allowActions) {
        super(project, true);
        this.myProject = project;
        this.myDstLabel = dstLabel;
        this.myDstName = dstName;
        this.myURL = url;
        this.myIsShowFiles = showFiles;
        this.myAllowActions = allowActions;
        this.setTitle(SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
        this.init();
    }

    @NotNull
    protected String getHelpId() {
        return HELP_ID;
    }

    protected String getDimensionServiceKey() {
        return "svn.repositoryBrowser";
    }

    @Nullable
    private static Url initRoot(Project project, Url url) throws SvnBindException {
        Ref result = new Ref();
        Ref excRef = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                result.set((Object)SvnUtil.getRepositoryRoot(SvnVcs.getInstance(project), url));
            }
            catch (SvnBindException e) {
                excRef.set((Object)e);
            }
        }, SvnBundle.message("progress.title.detecting.repository.root", new Object[0]), true, project);
        if (!excRef.isNull()) {
            throw (SvnBindException)((Object)excRef.get());
        }
        return (Url)result.get();
    }

    protected void init() {
        super.init();
        if (this.myAllowActions) {
            this.myRepositoryBrowser.setRepositoryURLs(new Url[]{this.myURL}, this.myIsShowFiles, new UrlOpeningExpander.Factory(this.myURL), true);
        } else {
            this.myRepositoryBrowser.setRepositoryURL(this.myURL, this.myIsShowFiles, new UrlOpeningExpander.Factory(this.myURL));
        }
        this.myRepositoryBrowser.addChangeListener(e -> this.getOKAction().setEnabled(this.isOKActionEnabled()));
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myRepositoryBrowser);
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        JPanel browserPanel = new JPanel();
        browserPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = JBUI.insets((int)2);
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.myRepositoryBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
        browserPanel.add((Component)this.myRepositoryBrowser, gc);
        if (this.myDstName != null) {
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.gridx = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            JLabel dstLabel = new JLabel(this.myDstLabel);
            browserPanel.add((Component)dstLabel, gc);
            ++gc.gridx;
            gc.weightx = 1.0;
            gc.fill = 2;
            this.myDstText = new JTextField();
            this.myDstText.setText(this.myDstName);
            this.myDstText.selectAll();
            browserPanel.add((Component)this.myDstText, gc);
            this.myDstText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }
            });
            dstLabel.setLabelFor(this.myDstText);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 2;
            browserPanel.add((Component)new JSeparator(), gc);
        }
        if (this.myAllowActions) {
            panel2.add((Component)this.createToolbar(), "North");
        }
        panel2.add((Component)browserPanel, "Center");
        return panel2;
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RepositoryBrowserDialog.EditLocationAction(this.myRepositoryBrowser));
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("RepositoryBrowser.Toolbar", (ActionGroup)group, true).getComponent();
        if (jComponent == null) {
            SelectLocationDialog.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myRepositoryBrowser.getPreferredFocusedComponent();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        boolean ok;
        boolean bl = ok = this.myRepositoryBrowser.getSelectedURL() != null;
        if (ok && this.myDstText != null) {
            return !this.myDstText.getText().trim().isEmpty();
        }
        return ok;
    }

    @NotNull
    public String getDestinationName() {
        String string = this.myDstText.getText().trim();
        if (string == null) {
            SelectLocationDialog.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public Url getSelectedURL() {
        return this.myRepositoryBrowser.getSelectedSVNURL();
    }

    @Nullable
    public Url getRootUrl() {
        RepositoryTreeNode node;
        for (node = this.myRepositoryBrowser.getSelectedNode(); node != null && node.getParent() instanceof RepositoryTreeNode; node = (RepositoryTreeNode)node.getParent()) {
        }
        return node != null ? node.getURL() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/SelectLocationDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/SelectLocationDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestinationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "selectLocation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectLocationAndRoot";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectCopyDestination";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openDialog";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

