/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.SSRBundle;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileTypeInfo {
    public static final FileTypeInfo[] EMPTY_ARRAY = new FileTypeInfo[0];
    private final LanguageFileType myFileType;
    private final Language myDialect;
    private final PatternContext myContext;
    private final boolean myNested;
    private final String myDescription;

    FileTypeInfo(@NotNull LanguageFileType fileType, @NotNull Language dialect, @Nullable PatternContext context, boolean nested) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            FileTypeInfo.$$$reportNull$$$0(1);
        }
        this.myFileType = fileType;
        this.myDialect = dialect;
        this.myContext = context;
        this.myNested = nested;
        this.myDescription = fileType.getDescription();
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = this.myFileType;
        if (languageFileType == null) {
            FileTypeInfo.$$$reportNull$$$0(2);
        }
        return languageFileType;
    }

    @Nullable
    public Language getDialect() {
        return this.myDialect;
    }

    @Nullable
    public PatternContext getContext() {
        return this.myContext;
    }

    @NlsSafe
    @NotNull
    public String getText() {
        if (this.myNested) {
            if (this.myDialect != null && this.myDialect != this.myFileType.getLanguage()) {
                String string = this.myDialect.getDisplayName();
                if (string == null) {
                    FileTypeInfo.$$$reportNull$$$0(3);
                }
                return string;
            }
            if (this.myContext != null) {
                String string = SSRBundle.message("file.type.pattern.context", this.myDescription, this.myContext.getDisplayName());
                if (string == null) {
                    FileTypeInfo.$$$reportNull$$$0(4);
                }
                return string;
            }
        }
        String string = this.myDescription;
        if (string == null) {
            FileTypeInfo.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isNested() {
        return this.myNested;
    }

    public boolean isEqualTo(@NotNull LanguageFileType fileType, @Nullable Language dialect, @Nullable PatternContext context) {
        if (fileType == null) {
            FileTypeInfo.$$$reportNull$$$0(6);
        }
        return !(this.myFileType != fileType || dialect != null && this.myDialect != dialect || context != null && this.myContext != context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileTypeInfo)) {
            return false;
        }
        FileTypeInfo info = (FileTypeInfo)o;
        return this.myFileType == info.myFileType && this.myDialect == info.myDialect && this.myContext == info.myContext;
    }

    public int hashCode() {
        return Objects.hash(this.myFileType, this.myDialect, this.myContext);
    }

    public String toString() {
        return this.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/FileTypeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/FileTypeInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEqualTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

