/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class GradleReflectionUtil {
    public static boolean hasMethod(@NotNull Object target, @NotNull String methodName, Class<?> ... parameterTypes) {
        if (target == null) {
            GradleReflectionUtil.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(1);
        }
        try {
            target.getClass().getMethod(methodName, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    @NotNull
    public static Method getMethod(@NotNull Class<?> receiverParameterType, @NotNull String methodName, Class<?> ... parameterTypes) {
        Method method;
        if (receiverParameterType == null) {
            GradleReflectionUtil.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(3);
        }
        if (parameterTypes == null) {
            GradleReflectionUtil.$$$reportNull$$$0(4);
        }
        try {
            method = receiverParameterType.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException(e);
        }
        if (method == null) {
            GradleReflectionUtil.$$$reportNull$$$0(5);
        }
        return method;
    }

    public static Object invokeMethod(@NotNull Method method, Object receiverArgument, Object ... arguments) {
        if (method == null) {
            GradleReflectionUtil.$$$reportNull$$$0(6);
        }
        try {
            return method.invoke(receiverArgument, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T getValue(@NotNull Object receiver, @NotNull String getterName, @NotNull Class<T> valueClass) {
        if (receiver == null) {
            GradleReflectionUtil.$$$reportNull$$$0(7);
        }
        if (getterName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(8);
        }
        if (valueClass == null) {
            GradleReflectionUtil.$$$reportNull$$$0(9);
        }
        Method method = GradleReflectionUtil.getMethod(receiver.getClass(), getterName, new Class[0]);
        Object value = GradleReflectionUtil.invokeMethod(method, receiver, new Object[0]);
        try {
            return valueClass.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> T getPrivateValue(@NotNull Object receiver, @NotNull String getterName, @NotNull Class<T> valueClass) {
        Method method;
        if (receiver == null) {
            GradleReflectionUtil.$$$reportNull$$$0(10);
        }
        if (getterName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(11);
        }
        if (valueClass == null) {
            GradleReflectionUtil.$$$reportNull$$$0(12);
        }
        Class<?> receiverClass = receiver.getClass();
        try {
            method = receiverClass.getDeclaredMethod(getterName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(String.format("The %s method are not found in %s", getterName, receiverClass.getCanonicalName()));
        }
        method.setAccessible(true);
        Object value = GradleReflectionUtil.invokeMethod(method, receiver, new Object[0]);
        try {
            return valueClass.cast(value);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T> void setValue(@NotNull Object receiver, @NotNull String setterName, @NotNull Class<T> valueClass, T value) {
        if (receiver == null) {
            GradleReflectionUtil.$$$reportNull$$$0(13);
        }
        if (setterName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(14);
        }
        if (valueClass == null) {
            GradleReflectionUtil.$$$reportNull$$$0(15);
        }
        Method method = GradleReflectionUtil.getMethod(receiver.getClass(), setterName, valueClass);
        GradleReflectionUtil.invokeMethod(method, receiver, value);
    }

    public static <T, V> T invokeMethod(@NotNull Object receiver, @NotNull String methodName, @NotNull V argument, @NotNull Class<V> argumentClass, @NotNull Class<T> resultClass) {
        if (receiver == null) {
            GradleReflectionUtil.$$$reportNull$$$0(16);
        }
        if (methodName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(17);
        }
        if (argument == null) {
            GradleReflectionUtil.$$$reportNull$$$0(18);
        }
        if (argumentClass == null) {
            GradleReflectionUtil.$$$reportNull$$$0(19);
        }
        if (resultClass == null) {
            GradleReflectionUtil.$$$reportNull$$$0(20);
        }
        Method method = GradleReflectionUtil.getMethod(receiver.getClass(), methodName, argumentClass);
        return resultClass.cast(GradleReflectionUtil.invokeMethod(method, receiver, argument));
    }

    @Deprecated
    public static <T> T reflectiveCall(@NotNull Object target, @NotNull String methodName, @NotNull Class<T> aClass) {
        if (target == null) {
            GradleReflectionUtil.$$$reportNull$$$0(21);
        }
        if (methodName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            GradleReflectionUtil.$$$reportNull$$$0(23);
        }
        try {
            Method method = target.getClass().getMethod(methodName, new Class[0]);
            Object value = method.invoke(target, new Object[0]);
            return aClass.cast(value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean isInstance(@NotNull Object object, String className) {
        Class<?> clazz;
        if (object == null) {
            GradleReflectionUtil.$$$reportNull$$$0(24);
        }
        return (clazz = GradleReflectionUtil.findClassForName(className)) != null && clazz.isInstance(object);
    }

    @Nullable
    public static Class<?> findClassForName(@NotNull String className) {
        if (className == null) {
            GradleReflectionUtil.$$$reportNull$$$0(25);
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException __) {
            return null;
        }
    }

    @Nullable
    public static Class<?> loadClassOrNull(@NotNull ClassLoader classLoader, @NotNull String className) {
        if (classLoader == null) {
            GradleReflectionUtil.$$$reportNull$$$0(26);
        }
        if (className == null) {
            GradleReflectionUtil.$$$reportNull$$$0(27);
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException __) {
            return null;
        }
    }

    @NotNull
    public static Class<?> getGradleClass(@NotNull String requiredClassName) {
        Class<?> requiredClass;
        if (requiredClassName == null) {
            GradleReflectionUtil.$$$reportNull$$$0(28);
        }
        if ((requiredClass = GradleReflectionUtil.findClassForName(requiredClassName)) == null) {
            throw new IllegalStateException(String.format("Class %s not found in the classpath of the Gradle daemon %s but it should be there!", requiredClass, GradleVersion.current().getBaseVersion()));
        }
        Class<?> clazz = requiredClass;
        if (clazz == null) {
            GradleReflectionUtil.$$$reportNull$$$0(29);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverParameterType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 5: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/util/GradleReflectionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterName";
                break;
            }
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setterName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/util/GradleReflectionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasMethod";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMethod";
                break;
            }
            case 5: 
            case 29: {
                break;
            }
            case 6: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPrivateValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reflectiveCall";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInstance";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findClassForName";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadClassOrNull";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGradleClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

