/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import jakarta.ejb.RemoveException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.core.stateful.StatefulEjbObjectHandler;
import org.apache.openejb.util.proxy.ProxyManager;

public class StatefulEjbHomeHandler
extends EjbHomeProxyHandler {
    public StatefulEjbHomeHandler(BeanContext beanContext, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        super(beanContext, interfaceType, interfaces, mainInterface);
    }

    @Override
    public Object createProxy(Object primaryKey, Class mainInterface) {
        Object proxy = super.createProxy(primaryKey, mainInterface);
        EjbObjectProxyHandler handler = null;
        try {
            handler = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(proxy);
        }
        catch (Exception e) {
            try {
                Field field = proxy.getClass().getDeclaredField("invocationHandler");
                field.setAccessible(true);
                handler = (EjbObjectProxyHandler)field.get(proxy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.registerHandler(handler.getRegistryId(), handler);
        return proxy;
    }

    @Override
    protected Object findX(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        throw new UnsupportedOperationException("Stateful beans may not have find methods");
    }

    @Override
    protected Object removeByPrimaryKey(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        throw new RemoveException("Session objects are private resources and do not have primary keys");
    }

    @Override
    protected EjbObjectProxyHandler newEjbObjectHandler(BeanContext beanContext, Object pk, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        return new StatefulEjbObjectHandler(this.getBeanContext(), pk, interfaceType, interfaces, mainInterface);
    }
}

