/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import jakarta.ejb.LockType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.BeanContext;
import org.apache.openejb.MethodContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.MethodAttributeInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyInfo;
import org.apache.openejb.assembler.classic.MethodInfo;
import org.apache.openejb.assembler.classic.MethodInfoUtil;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class MethodConcurrencyBuilder {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, MethodConcurrencyBuilder.class);

    public void build(HashMap<String, BeanContext> deployments, List<MethodConcurrencyInfo> methodConcurrencys) throws OpenEJBException {
        for (BeanContext beanContext : deployments.values()) {
            MethodConcurrencyBuilder.applyConcurrencyAttributes(beanContext, methodConcurrencys);
        }
    }

    public static void applyConcurrencyAttributes(BeanContext beanContext, List<MethodConcurrencyInfo> methodConcurrencyInfos) throws OpenEJBException {
        MethodContext methodContext;
        MethodConcurrencyInfo value;
        MethodConcurrencyInfo value2;
        Method method;
        if (beanContext.isBeanManagedConcurrency()) {
            return;
        }
        Logger log = Logger.getInstance(LogCategory.OPENEJB_STARTUP.createChild("attributes"), MethodConcurrencyBuilder.class);
        ArrayList<MethodConcurrencyInfo> lockInfos = new ArrayList<MethodConcurrencyInfo>();
        ArrayList<MethodConcurrencyInfo> accessTimeoutInfos = new ArrayList<MethodConcurrencyInfo>();
        MethodConcurrencyBuilder.normalize(methodConcurrencyInfos, lockInfos, accessTimeoutInfos);
        Map<Method, MethodAttributeInfo> attributes = MethodInfoUtil.resolveAttributes(lockInfos, beanContext);
        if (log.isDebugEnabled()) {
            for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
                method = entry.getKey();
                value2 = (MethodConcurrencyInfo)entry.getValue();
                log.debug("Lock: " + method + " -- " + MethodInfoUtil.toString((MethodInfo)value2.methods.get(0)) + " " + value2.concurrencyAttribute);
            }
        }
        for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
            value = (MethodConcurrencyInfo)entry.getValue();
            methodContext = beanContext.getMethodContext(entry.getKey());
            String s = value.concurrencyAttribute.toUpperCase();
            methodContext.setLockType(LockType.valueOf((String)s));
        }
        attributes = MethodInfoUtil.resolveAttributes(accessTimeoutInfos, beanContext);
        if (log.isDebugEnabled()) {
            for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
                method = entry.getKey();
                value2 = (MethodConcurrencyInfo)entry.getValue();
                log.debug("AccessTimeout: " + method + " -- " + MethodInfoUtil.toString((MethodInfo)value2.methods.get(0)) + "  " + value2.accessTimeout.time + " " + value2.accessTimeout.unit);
            }
        }
        for (Map.Entry<Method, MethodAttributeInfo> entry : attributes.entrySet()) {
            value = (MethodConcurrencyInfo)entry.getValue();
            methodContext = beanContext.getMethodContext(entry.getKey());
            Duration accessTimeout = new Duration(value.accessTimeout.time, TimeUnit.valueOf(value.accessTimeout.unit));
            methodContext.setAccessTimeout(accessTimeout);
        }
    }

    public static void normalize(List<MethodConcurrencyInfo> infos, List<MethodConcurrencyInfo> lockInfos, List<MethodConcurrencyInfo> accessTimeoutInfos) {
        for (MethodConcurrencyInfo oldInfo : infos) {
            for (MethodInfo methodInfo : oldInfo.methods) {
                MethodConcurrencyInfo newInfo = new MethodConcurrencyInfo();
                newInfo.description = oldInfo.description;
                newInfo.methods.add(methodInfo);
                newInfo.concurrencyAttribute = oldInfo.concurrencyAttribute;
                newInfo.accessTimeout = oldInfo.accessTimeout;
                if (oldInfo.concurrencyAttribute != null) {
                    lockInfos.add(newInfo);
                }
                if (oldInfo.accessTimeout == null) continue;
                accessTimeoutInfos.add(newInfo);
            }
        }
        Collections.reverse(lockInfos);
        lockInfos.sort(new MethodConcurrencyComparator());
        Collections.reverse(accessTimeoutInfos);
        accessTimeoutInfos.sort(new MethodConcurrencyComparator());
    }

    public static class MethodConcurrencyComparator
    extends MethodInfoUtil.BaseComparator<MethodConcurrencyInfo> {
        @Override
        public int compare(MethodConcurrencyInfo a, MethodConcurrencyInfo b) {
            return this.compare((MethodInfo)a.methods.get(0), (MethodInfo)b.methods.get(0));
        }
    }
}

