<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

# [0.20.0](https://github.com/apache/superset/compare/v2021.41.0...v0.20.0) (2024-09-09)

### Bug Fixes

- Right click on country map with code filter ([#22081](https://github.com/apache/superset/issues/22081)) ([824dc71](https://github.com/apache/superset/commit/824dc7188b953270ca754f96ca615e96c61dbea4))
- Right-click on misconfigured World Map ([#21697](https://github.com/apache/superset/issues/21697)) ([770f68f](https://github.com/apache/superset/commit/770f68f5b187b573f50f53a80d9cfffb24f0c583))
- World Map right-click value ([#21209](https://github.com/apache/superset/issues/21209)) ([d41f44f](https://github.com/apache/superset/commit/d41f44fcdf387072bc5d7700a5e8871c6594baef))
- **world-map:** remove categorical color option ([#19781](https://github.com/apache/superset/issues/19781)) ([5e468f7](https://github.com/apache/superset/commit/5e468f7a4cccc496ccafa52f9aba5b7688145fe4))

### Features

- Add currencies controls in control panels ([#24718](https://github.com/apache/superset/issues/24718)) ([f7e76d0](https://github.com/apache/superset/commit/f7e76d02b7cbe4940946673590bb979984ace9f5))
- Adds drill to detail context menu to Pivot Table ([#21198](https://github.com/apache/superset/issues/21198)) ([859b6d2](https://github.com/apache/superset/commit/859b6d2d20a58f2079c43bb66645fd3b604e077e))
- Adds drill to detail context menu to World Map ([#21150](https://github.com/apache/superset/issues/21150)) ([4ca4a5c](https://github.com/apache/superset/commit/4ca4a5c7cb185ac7d318ef5349fbb23cd7ce1fd1))
- Adds the Featured Charts dashboard ([#28789](https://github.com/apache/superset/issues/28789)) ([95706d9](https://github.com/apache/superset/commit/95706d9be2b5414ed496ad762ba1996041429e01))
- apply standardized form data to tier 2 charts ([#20530](https://github.com/apache/superset/issues/20530)) ([de524bc](https://github.com/apache/superset/commit/de524bc59f011fd361dcdb7d35c2cb51f7eba442))
- **dashboard:** Add cross filter from context menu ([#23141](https://github.com/apache/superset/issues/23141)) ([ee1952e](https://github.com/apache/superset/commit/ee1952e488f2cd0913fe6f35ffe551d18ee3d143))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- Enable cross fitlers in WorldMap and Graph charts ([#22886](https://github.com/apache/superset/issues/22886)) ([871cab8](https://github.com/apache/superset/commit/871cab8cbe20971efd9b81f647ed537ad4fbe12b))
- **explore:** Denormalize form data in echarts, world map and nvd3 bar and line charts ([#20313](https://github.com/apache/superset/issues/20313)) ([354a899](https://github.com/apache/superset/commit/354a89950c4d001da3e107f60788cea873bd6bf6))
- Implement context menu for drill by ([#23454](https://github.com/apache/superset/issues/23454)) ([9fbfd1c](https://github.com/apache/superset/commit/9fbfd1c1d883f983ef96b8812297721e2a1a9695))
- Implement support for currencies in more charts ([#24594](https://github.com/apache/superset/issues/24594)) ([d74d7ec](https://github.com/apache/superset/commit/d74d7eca23a3c94bc48af082c115d34c103e815d))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- **viz picker:** Remove some tags, refactor Recommended section ([#27708](https://github.com/apache/superset/issues/27708)) ([c314999](https://github.com/apache/superset/commit/c3149994ac0d4392e0462421b62cd0c034142082))
- **world-map:** support color by metric or country column ([#19881](https://github.com/apache/superset/issues/19881)) ([766f737](https://github.com/apache/superset/commit/766f737728c273d39a35dfa281e874a0efeabec3))

# [0.19.0](https://github.com/apache/superset/compare/v2021.41.0...v0.19.0) (2024-09-07)

### Bug Fixes

- Right click on country map with code filter ([#22081](https://github.com/apache/superset/issues/22081)) ([824dc71](https://github.com/apache/superset/commit/824dc7188b953270ca754f96ca615e96c61dbea4))
- Right-click on misconfigured World Map ([#21697](https://github.com/apache/superset/issues/21697)) ([770f68f](https://github.com/apache/superset/commit/770f68f5b187b573f50f53a80d9cfffb24f0c583))
- World Map right-click value ([#21209](https://github.com/apache/superset/issues/21209)) ([d41f44f](https://github.com/apache/superset/commit/d41f44fcdf387072bc5d7700a5e8871c6594baef))
- **world-map:** remove categorical color option ([#19781](https://github.com/apache/superset/issues/19781)) ([5e468f7](https://github.com/apache/superset/commit/5e468f7a4cccc496ccafa52f9aba5b7688145fe4))

### Features

- Add currencies controls in control panels ([#24718](https://github.com/apache/superset/issues/24718)) ([f7e76d0](https://github.com/apache/superset/commit/f7e76d02b7cbe4940946673590bb979984ace9f5))
- Adds drill to detail context menu to Pivot Table ([#21198](https://github.com/apache/superset/issues/21198)) ([859b6d2](https://github.com/apache/superset/commit/859b6d2d20a58f2079c43bb66645fd3b604e077e))
- Adds drill to detail context menu to World Map ([#21150](https://github.com/apache/superset/issues/21150)) ([4ca4a5c](https://github.com/apache/superset/commit/4ca4a5c7cb185ac7d318ef5349fbb23cd7ce1fd1))
- Adds the Featured Charts dashboard ([#28789](https://github.com/apache/superset/issues/28789)) ([95706d9](https://github.com/apache/superset/commit/95706d9be2b5414ed496ad762ba1996041429e01))
- apply standardized form data to tier 2 charts ([#20530](https://github.com/apache/superset/issues/20530)) ([de524bc](https://github.com/apache/superset/commit/de524bc59f011fd361dcdb7d35c2cb51f7eba442))
- **dashboard:** Add cross filter from context menu ([#23141](https://github.com/apache/superset/issues/23141)) ([ee1952e](https://github.com/apache/superset/commit/ee1952e488f2cd0913fe6f35ffe551d18ee3d143))
- **dashboard:** menu improvements, fallback support for Drill to Detail ([#21351](https://github.com/apache/superset/issues/21351)) ([76e57ec](https://github.com/apache/superset/commit/76e57ec651bbfaf4f76031eeeca66f6a1fa81bc2))
- Enable cross fitlers in WorldMap and Graph charts ([#22886](https://github.com/apache/superset/issues/22886)) ([871cab8](https://github.com/apache/superset/commit/871cab8cbe20971efd9b81f647ed537ad4fbe12b))
- **explore:** Denormalize form data in echarts, world map and nvd3 bar and line charts ([#20313](https://github.com/apache/superset/issues/20313)) ([354a899](https://github.com/apache/superset/commit/354a89950c4d001da3e107f60788cea873bd6bf6))
- Implement context menu for drill by ([#23454](https://github.com/apache/superset/issues/23454)) ([9fbfd1c](https://github.com/apache/superset/commit/9fbfd1c1d883f983ef96b8812297721e2a1a9695))
- Implement support for currencies in more charts ([#24594](https://github.com/apache/superset/issues/24594)) ([d74d7ec](https://github.com/apache/superset/commit/d74d7eca23a3c94bc48af082c115d34c103e815d))
- improve color consistency (save all labels) ([#19038](https://github.com/apache/superset/issues/19038)) ([dc57508](https://github.com/apache/superset/commit/dc575080d7e43d40b1734bb8f44fdc291cb95b11))
- **viz picker:** Remove some tags, refactor Recommended section ([#27708](https://github.com/apache/superset/issues/27708)) ([c314999](https://github.com/apache/superset/commit/c3149994ac0d4392e0462421b62cd0c034142082))
- **world-map:** support color by metric or country column ([#19881](https://github.com/apache/superset/issues/19881)) ([766f737](https://github.com/apache/superset/commit/766f737728c273d39a35dfa281e874a0efeabec3))

# [0.18.0](https://github.com/apache-superset/superset-ui/compare/v0.17.87...v0.18.0) (2021-08-30)

**Note:** Version bump only for package @superset-ui/legacy-plugin-chart-world-map

## [0.17.61](https://github.com/apache-superset/superset-ui/compare/v0.17.60...v0.17.61) (2021-07-02)

**Note:** Version bump only for package @superset-ui/legacy-plugin-chart-world-map
