/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package org.apache.streampipes.model.mail;

import java.util.List;

public class SpEmail {

  private List<String> recipients;
  private String preheader;
  private String subject;
  private String message;

  public SpEmail() {
  }

  public SpEmail(List<String> recipients,
                 String subject,
                 String preheader,
                 String message) {
    this.recipients = recipients;
    this.subject = subject;
    this.preheader = preheader;
    this.message = message;
  }

  public static SpEmail from(List<String> recipients,
                             String subject,
                             String message) {
    return new SpEmail(recipients, subject, "", message);
  }

  public static SpEmail from(List<String> recipients,
                             String subject,
                             String preheader,
                             String message) {
    return new SpEmail(recipients, subject, preheader, message);
  }

  public List<String> getRecipients() {
    return recipients;
  }

  public void setRecipients(List<String> recipients) {
    this.recipients = recipients;
  }

  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public String getPreheader() {
    return preheader;
  }

  public void setPreheader(String preheader) {
    this.preheader = preheader;
  }

  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }
}
