/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ChildResourceInjector;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.classes.ResourceModelWithRequiredField;
import org.apache.sling.models.testmodels.interfaces.ChildModel;
import org.apache.sling.models.testmodels.interfaces.ChildResourceModel;
import org.apache.sling.models.testmodels.interfaces.ChildValueMapModel;
import org.apache.sling.models.testmodels.interfaces.ParentModel;
import org.apache.sling.models.testmodels.interfaces.SimplePropertyModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class ResourceModelInterfacesTest {
    private ModelAdapterFactory factory;

    ResourceModelInterfacesTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new ChildResourceInjector(), new ValueMapInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{SimplePropertyModel.class, ResourceModelWithRequiredField.class, ChildResourceModel.class, ChildValueMapModel.class, ParentModel.class, ChildModel.class});
    }

    @Test
    void testSimplePropertyModel() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("first", "first-value");
        map.put("third", "third-value");
        map.put("fourth", true);
        ValueMapDecorator vm = new ValueMapDecorator(map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        SimplePropertyModel model = (SimplePropertyModel)this.factory.getAdapter((Object)res, SimplePropertyModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)"first-value", (Object)model.getFirst());
        Assertions.assertNull((Object)model.getSecond());
        Assertions.assertEquals((Object)"third-value", (Object)model.getThirdProperty());
        Assertions.assertTrue((boolean)model.isFourth());
        ((Resource)Mockito.verify((Object)res, (VerificationMode)Mockito.times((int)1))).adaptTo(ValueMap.class);
    }

    @Test
    void testRequiredPropertyModel() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("first", "first-value");
        map.put("third", "third-value");
        ValueMap vm = (ValueMap)Mockito.spy((Object)new ValueMapDecorator(map));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ResourceModelWithRequiredField model = (ResourceModelWithRequiredField)this.factory.getAdapter((Object)res, ResourceModelWithRequiredField.class);
        Assertions.assertNull((Object)model);
        ((ValueMap)Mockito.verify((Object)vm)).get("required", String.class);
    }

    @Test
    void testChildResource() {
        Resource child = (Resource)Mockito.mock(Resource.class);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)res.getChild("firstChild")).thenReturn((Object)child);
        ChildResourceModel model = (ChildResourceModel)this.factory.getAdapter((Object)res, ChildResourceModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)child, (Object)model.getFirstChild());
    }

    @Test
    void testChildValueMap() {
        ValueMap map = ValueMapDecorator.EMPTY;
        Resource child = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)((ValueMap)child.adaptTo(ValueMap.class))).thenReturn((Object)map);
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)res.getChild("firstChild")).thenReturn((Object)child);
        ChildValueMapModel model = (ChildValueMapModel)this.factory.getAdapter((Object)res, ChildValueMapModel.class);
        Assertions.assertNotNull((Object)model);
        Assertions.assertEquals((Object)map, (Object)model.getFirstChild());
    }

    @Test
    void testChildModel() {
        String value = RandomStringUtils.secureStrong().nextAlphabetic(10);
        Map<String, String> props = Collections.singletonMap("property", value);
        ValueMapDecorator map = new ValueMapDecorator(props);
        Resource firstChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)firstChild.adaptTo(ValueMap.class))).thenReturn((Object)map);
        Mockito.lenient().when((Object)((ChildModel)firstChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        String firstGrandChildValue = RandomStringUtils.secureStrong().nextAlphabetic(10);
        ValueMapDecorator firstGrandChildMap = new ValueMapDecorator(Collections.singletonMap("property", firstGrandChildValue));
        String secondGrandChildValue = RandomStringUtils.secureStrong().nextAlphabetic(10);
        ValueMapDecorator secondGrandChildMap = new ValueMapDecorator(Collections.singletonMap("property", secondGrandChildValue));
        Resource firstGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)firstGrandChild.adaptTo(ValueMap.class))).thenReturn((Object)firstGrandChildMap);
        Mockito.lenient().when((Object)((ChildModel)firstGrandChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        Resource secondGrandChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)secondGrandChild.adaptTo(ValueMap.class))).thenReturn((Object)secondGrandChildMap);
        Mockito.lenient().when((Object)((ChildModel)secondGrandChild.adaptTo(ChildModel.class))).thenAnswer((Answer)new AdaptToChildModel());
        Resource secondChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)secondChild.listChildren()).thenReturn(Arrays.asList(firstGrandChild, secondGrandChild).iterator());
        Resource emptyChild = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)emptyChild.listChildren()).thenReturn(Collections.emptySet().iterator());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)res.getChild("firstChild")).thenReturn((Object)firstChild);
        Mockito.lenient().when((Object)res.getChild("secondChild")).thenReturn((Object)secondChild);
        Mockito.lenient().when((Object)res.getChild("emptyChild")).thenReturn((Object)emptyChild);
        ParentModel model = (ParentModel)this.factory.getAdapter((Object)res, ParentModel.class);
        Assertions.assertNotNull((Object)model);
        ChildModel childModel = model.getFirstChild();
        Assertions.assertNotNull((Object)childModel);
        Assertions.assertEquals((Object)value, (Object)childModel.getProperty());
        Assertions.assertEquals((int)2, (int)model.getGrandChildren().size());
        Assertions.assertEquals((Object)firstGrandChildValue, (Object)model.getGrandChildren().get(0).getProperty());
        Assertions.assertEquals((Object)secondGrandChildValue, (Object)model.getGrandChildren().get(1).getProperty());
        Assertions.assertEquals((int)0, (int)model.getEmptyGrandChildren().size());
    }

    private class AdaptToChildModel
    implements Answer<ChildModel> {
        private AdaptToChildModel() {
        }

        public ChildModel answer(InvocationOnMock invocation) throws Throwable {
            return (ChildModel)ResourceModelInterfacesTest.this.factory.getAdapter(invocation.getMock(), ChildModel.class);
        }
    }
}

