/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.BindingsInjector;
import org.apache.sling.models.testmodels.classes.constructorinjection.BindingsModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
class RequestInjectionTest {
    private ModelAdapterFactory factory;
    @Mock
    private SlingJakartaHttpServletRequest request;
    @Mock
    private SlingScriptHelper sling;

    RequestInjectionTest() {
    }

    @BeforeEach
    void setup() {
        SlingBindings bindings = new SlingBindings();
        bindings.setSling(this.sling);
        bindings.setLog(LoggerFactory.getLogger((String)"test"));
        Mockito.lenient().when(this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)bindings);
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new BindingsInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{org.apache.sling.models.testmodels.classes.BindingsModel.class, BindingsModel.class});
    }

    @Test
    void testNamedInjectionField() {
        org.apache.sling.models.testmodels.classes.BindingsModel model = (org.apache.sling.models.testmodels.classes.BindingsModel)this.factory.getAdapter((Object)this.request, org.apache.sling.models.testmodels.classes.BindingsModel.class);
        Assertions.assertNotNull((Object)model.getSling());
        Assertions.assertEquals((Object)this.sling, (Object)model.getSling());
        Assertions.assertEquals((Object)"test", (Object)model.getLog().getName());
        ((SlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getAttribute(SlingBindings.class.getName());
    }

    @Test
    void testNamedInjectionConstructor() {
        BindingsModel model = (BindingsModel)this.factory.getAdapter((Object)this.request, BindingsModel.class);
        Assertions.assertNotNull((Object)model.getSling());
        Assertions.assertEquals((Object)this.sling, (Object)model.getSling());
        Assertions.assertEquals((Object)"test", (Object)model.getLog().getName());
        ((SlingJakartaHttpServletRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.times((int)1))).getAttribute(SlingBindings.class.getName());
    }
}

