/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.impl.injectors.SelfInjector;
import org.apache.sling.models.testmodels.classes.constructorvisibility.PackagePrivateConstructorModel;
import org.apache.sling.models.testmodels.classes.constructorvisibility.PrivateConstructorModel;
import org.apache.sling.models.testmodels.classes.constructorvisibility.ProtectedConstructorModel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ConstructorVisibilityTest {
    private ModelAdapterFactory factory;
    @Mock
    private SlingJakartaHttpServletRequest request;

    ConstructorVisibilityTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(new RequestAttributeInjector(), new SelfInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ProtectedConstructorModel.class, PackagePrivateConstructorModel.class, PrivateConstructorModel.class});
    }

    @Test
    void testNonPublicConstructorProtectedModel() {
        ProtectedConstructorModel model = (ProtectedConstructorModel)this.factory.createModel((Object)this.request, ProtectedConstructorModel.class);
        Assertions.assertNotNull((Object)model);
    }

    @Test
    void testNonPublicConstructorPackagePrivateModel() {
        PackagePrivateConstructorModel model = (PackagePrivateConstructorModel)this.factory.createModel((Object)this.request, PackagePrivateConstructorModel.class);
        Assertions.assertNotNull((Object)model);
    }

    @Test
    void testNonPublicConstructorPrivateModel() {
        PrivateConstructorModel model = (PrivateConstructorModel)this.factory.createModel((Object)this.request, PrivateConstructorModel.class);
        Assertions.assertNotNull((Object)model);
    }
}

