/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.cloud.gateway.v21x;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.spring.cloud.gateway.v21x.define.EnhanceObjectCache;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.SignalType;

public class HttpClientFinalizerResponseConnectionInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) {
        BiFunction finalReceiver = (BiFunction)allArguments[0];
        EnhanceObjectCache cache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
        allArguments[0] = (response, connection) -> {
            Publisher publisher = (Publisher)finalReceiver.apply(response, connection);
            if (cache.getSpan() != null) {
                if (response.status().code() >= HttpResponseStatus.BAD_REQUEST.code()) {
                    cache.getSpan().errorOccurred();
                }
                Tags.HTTP_RESPONSE_STATUS_CODE.set(cache.getSpan(), Integer.valueOf(response.status().code()));
            }
            return publisher;
        };
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        Flux responseFlux = (Flux)ret;
        responseFlux = responseFlux.doOnError(e -> {
            EnhanceObjectCache cache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
            if (cache == null) {
                return;
            }
            if (cache.getSpan() != null) {
                cache.getSpan().errorOccurred();
                cache.getSpan().log(e);
            }
        }).doFinally(signalType -> {
            EnhanceObjectCache cache = (EnhanceObjectCache)objInst.getSkyWalkingDynamicField();
            if (cache == null) {
                return;
            }
            if (cache.getSpan() != null) {
                if (signalType == SignalType.CANCEL) {
                    cache.getSpan().errorOccurred();
                }
                cache.getSpan().asyncFinish();
            }
            if (cache.getSpan1() != null) {
                cache.getSpan1().asyncFinish();
            }
        });
        return responseFlux;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

