/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.dependencies.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.Uuid;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Message;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Readable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.Writable;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Field;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Schema;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.protocol.types.Type;
import org.apache.skywalking.apm.dependencies.org.apache.kafka.common.utils.ByteUtils;

public class MetadataRequestData
implements ApiMessage {
    List<MetadataRequestTopic> topics;
    boolean allowAutoTopicCreation;
    boolean includeClusterAuthorizedOperations;
    boolean includeTopicAuthorizedOperations;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema SCHEMA_12;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 12;

    public MetadataRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public MetadataRequestData() {
        this.topics = new ArrayList<MetadataRequestTopic>(0);
        this.allowAutoTopicCreation = true;
        this.includeClusterAuthorizedOperations = false;
        this.includeTopicAuthorizedOperations = false;
    }

    @Override
    public short apiKey() {
        return 3;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 12;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void read(Readable _readable, short _version) {
        int i;
        ArrayList<MetadataRequestTopic> newCollection;
        int arrayLength;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.topics = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataRequestTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                if (_version < 1) throw new RuntimeException("non-nullable field topics was serialized as null");
                this.topics = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<MetadataRequestTopic>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MetadataRequestTopic(_readable, _version));
                }
                this.topics = newCollection;
            }
        }
        this.allowAutoTopicCreation = _version >= 4 ? _readable.readByte() != 0 : true;
        this.includeClusterAuthorizedOperations = _version >= 8 && _version <= 10 ? _readable.readByte() != 0 : false;
        this.includeTopicAuthorizedOperations = _version >= 8 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version < 9) return;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 9) {
            if (this.topics == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                for (MetadataRequestTopic topicsElement : this.topics) {
                    topicsElement.write(_writable, _cache, _version);
                }
            }
        } else if (this.topics == null) {
            if (_version < 1) throw new NullPointerException();
            _writable.writeInt(-1);
        } else {
            _writable.writeInt(this.topics.size());
            for (MetadataRequestTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        if (_version >= 4) {
            _writable.writeByte(this.allowAutoTopicCreation ? (byte)1 : 0);
        } else if (!this.allowAutoTopicCreation) {
            throw new UnsupportedVersionException("Attempted to write a non-default allowAutoTopicCreation at version " + _version);
        }
        if (_version >= 8 && _version <= 10) {
            _writable.writeByte(this.includeClusterAuthorizedOperations ? (byte)1 : 0);
        } else if (this.includeClusterAuthorizedOperations) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeClusterAuthorizedOperations at version " + _version);
        }
        if (_version >= 8) {
            _writable.writeByte(this.includeTopicAuthorizedOperations ? (byte)1 : 0);
        } else if (this.includeTopicAuthorizedOperations) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeTopicAuthorizedOperations at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 9) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            return;
        } else {
            if (_numTaggedFields <= 0) return;
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (this.topics == null) {
            if (_version >= 9) {
                _size.addBytes(1);
            } else {
                _size.addBytes(4);
            }
        } else {
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (MetadataRequestTopic topicsElement : this.topics) {
                topicsElement.addSize(_size, _cache, _version);
            }
        }
        if (_version >= 4) {
            _size.addBytes(1);
        }
        if (_version >= 8 && _version <= 10) {
            _size.addBytes(1);
        }
        if (_version >= 8) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetadataRequestData)) {
            return false;
        }
        MetadataRequestData other = (MetadataRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.allowAutoTopicCreation != other.allowAutoTopicCreation) {
            return false;
        }
        if (this.includeClusterAuthorizedOperations != other.includeClusterAuthorizedOperations) {
            return false;
        }
        if (this.includeTopicAuthorizedOperations != other.includeTopicAuthorizedOperations) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + (this.allowAutoTopicCreation ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.includeClusterAuthorizedOperations ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.includeTopicAuthorizedOperations ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public MetadataRequestData duplicate() {
        MetadataRequestData _duplicate = new MetadataRequestData();
        if (this.topics == null) {
            _duplicate.topics = null;
        } else {
            ArrayList<MetadataRequestTopic> newTopics = new ArrayList<MetadataRequestTopic>(this.topics.size());
            for (MetadataRequestTopic _element : this.topics) {
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
        }
        _duplicate.allowAutoTopicCreation = this.allowAutoTopicCreation;
        _duplicate.includeClusterAuthorizedOperations = this.includeClusterAuthorizedOperations;
        _duplicate.includeTopicAuthorizedOperations = this.includeTopicAuthorizedOperations;
        return _duplicate;
    }

    public String toString() {
        return "MetadataRequestData(topics=" + (this.topics == null ? "null" : MessageUtil.deepToString(this.topics.iterator())) + ", allowAutoTopicCreation=" + (this.allowAutoTopicCreation ? "true" : "false") + ", includeClusterAuthorizedOperations=" + (this.includeClusterAuthorizedOperations ? "true" : "false") + ", includeTopicAuthorizedOperations=" + (this.includeTopicAuthorizedOperations ? "true" : "false") + ")";
    }

    public List<MetadataRequestTopic> topics() {
        return this.topics;
    }

    public boolean allowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    public boolean includeClusterAuthorizedOperations() {
        return this.includeClusterAuthorizedOperations;
    }

    public boolean includeTopicAuthorizedOperations() {
        return this.includeTopicAuthorizedOperations;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public MetadataRequestData setTopics(List<MetadataRequestTopic> v) {
        this.topics = v;
        return this;
    }

    public MetadataRequestData setAllowAutoTopicCreation(boolean v) {
        this.allowAutoTopicCreation = v;
        return this;
    }

    public MetadataRequestData setIncludeClusterAuthorizedOperations(boolean v) {
        this.includeClusterAuthorizedOperations = v;
        return this;
    }

    public MetadataRequestData setIncludeTopicAuthorizedOperations(boolean v) {
        this.includeTopicAuthorizedOperations = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for.")));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."))));
        SCHEMA_8 = new Schema(new Field("topics", ArrayOf.nullable(MetadataRequestTopic.SCHEMA_0), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."), new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("include_topic_authorized_operations", Type.BOOLEAN, "Whether to include topic authorized operations."));
        SCHEMA_9 = new Schema(new Field("topics", CompactArrayOf.nullable(MetadataRequestTopic.SCHEMA_9), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."), new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("include_topic_authorized_operations", Type.BOOLEAN, "Whether to include topic authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_10 = new Schema(new Field("topics", CompactArrayOf.nullable(MetadataRequestTopic.SCHEMA_10), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."), new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("include_topic_authorized_operations", Type.BOOLEAN, "Whether to include topic authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_12 = SCHEMA_11 = new Schema(new Field("topics", CompactArrayOf.nullable(MetadataRequestTopic.SCHEMA_10), "The topics to fetch metadata for."), new Field("allow_auto_topic_creation", Type.BOOLEAN, "If this is true, the broker may auto-create topics that we requested which do not already exist, if it is configured to do so."), new Field("include_topic_authorized_operations", Type.BOOLEAN, "Whether to include topic authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
    }

    public static class MetadataRequestTopic
    implements Message {
        Uuid topicId;
        String name;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 12;

        public MetadataRequestTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MetadataRequestTopic() {
            this.topicId = Uuid.ZERO_UUID;
            this.name = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 12;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void read(Readable _readable, short _version) {
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MetadataRequestTopic");
            }
            this.topicId = _version >= 10 ? _readable.readUuid() : Uuid.ZERO_UUID;
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                if (_version < 10) throw new RuntimeException("non-nullable field name was serialized as null");
                this.name = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field name had invalid length " + length);
                }
                this.name = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            if (_version < 9) return;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version >= 10) {
                _writable.writeUuid(this.topicId);
            }
            if (this.name == null) {
                if (_version < 10) throw new NullPointerException();
                _writable.writeUnsignedVarint(0);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.name);
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
                return;
            } else {
                if (_numTaggedFields <= 0) return;
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 12) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MetadataRequestTopic");
            }
            if (_version >= 10) {
                _size.addBytes(16);
            }
            if (this.name == null) {
                if (_version >= 9) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'name' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.name, _stringBytes);
                if (_version >= 9) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MetadataRequestTopic)) {
                return false;
            }
            MetadataRequestTopic other = (MetadataRequestTopic)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public MetadataRequestTopic duplicate() {
            MetadataRequestTopic _duplicate = new MetadataRequestTopic();
            _duplicate.topicId = this.topicId;
            _duplicate.name = this.name == null ? null : this.name;
            return _duplicate;
        }

        public String toString() {
            return "MetadataRequestTopic(topicId=" + this.topicId.toString() + ", name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public String name() {
            return this.name;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MetadataRequestTopic setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public MetadataRequestTopic setName(String v) {
            this.name = v;
            return this;
        }

        static {
            SCHEMA_8 = SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = (SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name.")))))))));
            SCHEMA_9 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_12 = SCHEMA_11 = (SCHEMA_10 = new Schema(new Field("topic_id", Type.UUID, "The topic id."), new Field("name", Type.COMPACT_NULLABLE_STRING, "The topic name."), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12};
        }
    }
}

