/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.armeria;

import com.linecorp.armeria.client.UserClient;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import io.netty.util.AsciiString;
import java.lang.reflect.Method;
import java.net.URI;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class Armeria084ClientInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        UserClient userClient = (UserClient)objInst;
        URI uri = userClient.uri();
        HttpMethod httpMethod = (HttpMethod)allArguments[1];
        String path = (String)allArguments[2];
        Object req = allArguments[5];
        if (!(req instanceof HttpRequest)) {
            return;
        }
        HttpRequest httpReq = (HttpRequest)req;
        ContextCarrier contextCarrier = new ContextCarrier();
        String remotePeer = uri.getHost() + ":" + uri.getPort();
        AbstractSpan exitSpan = ContextManager.createExitSpan((String)path, (ContextCarrier)contextCarrier, (String)remotePeer);
        exitSpan.setComponent((Component)ComponentsDefine.ARMERIA);
        exitSpan.setLayer(SpanLayer.HTTP);
        Tags.HTTP.METHOD.set(exitSpan, httpMethod.name());
        HttpHeaders headers = httpReq.headers();
        CarrierItem item = contextCarrier.items();
        while (item.hasNext()) {
            item = item.next();
            headers.add((Object)AsciiString.of((CharSequence)item.getHeadKey()), (Object)item.getHeadValue());
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) {
        Object req = allArguments[5];
        if (req instanceof HttpRequest && ContextManager.isActive()) {
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }
}

