/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Objects;
import java.util.Vector;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.util.Disposable;

abstract class ImageAdapter
extends PlanarImage {
    protected final RenderedImage source;

    protected ImageAdapter(RenderedImage source) {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public final Vector<RenderedImage> getSources() {
        Vector<RenderedImage> sources = new Vector<RenderedImage>(1);
        sources.add(this.source);
        return sources;
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public final SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public final int getWidth() {
        return this.source.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.source.getHeight();
    }

    @Override
    public final int getMinX() {
        return this.source.getMinX();
    }

    @Override
    public final int getMinY() {
        return this.source.getMinY();
    }

    @Override
    public final int getNumXTiles() {
        return this.source.getNumXTiles();
    }

    @Override
    public final int getNumYTiles() {
        return this.source.getNumYTiles();
    }

    @Override
    public final int getMinTileX() {
        return this.source.getMinTileX();
    }

    @Override
    public final int getMinTileY() {
        return this.source.getMinTileY();
    }

    @Override
    public final int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public final int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public final int getTileGridXOffset() {
        return this.source.getTileGridXOffset();
    }

    @Override
    public final int getTileGridYOffset() {
        return this.source.getTileGridYOffset();
    }

    @Override
    public final Raster getTile(int tx, int ty) {
        return this.source.getTile(tx, ty);
    }

    @Override
    public final Raster getData() {
        return this.source.getData();
    }

    @Override
    public final Raster getData(Rectangle region) {
        return this.source.getData(region);
    }

    @Override
    public final WritableRaster copyData(WritableRaster r) {
        return this.source.copyData(r);
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        if (this.source instanceof PlanarImage) {
            return ((PlanarImage)this.source).prefetch(tiles);
        }
        return super.prefetch(tiles);
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            return this.source.equals(((ImageAdapter)object).source);
        }
        return false;
    }

    public int hashCode() {
        return this.source.hashCode() ^ this.getClass().hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(100);
        Class<? extends ImageAdapter> subtype = this.appendStringContent(buffer.append('['));
        return buffer.insert(0, subtype.getSimpleName()).append(" on ").append(this.source).append(']').toString();
    }

    abstract Class<? extends ImageAdapter> appendStringContent(StringBuilder var1);
}

