/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.math;

import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.shared.Numerics;

public final class DecimalFunctions {
    static final int EXPONENT_FOR_ZERO = -324;
    static final int EXPONENT_FOR_MAX = 308;
    private static final double[] POW10 = new double[632];

    private DecimalFunctions() {
    }

    static double pow10(int x) {
        return (x += 323) >= 0 ? (x < POW10.length ? POW10[x] : Double.POSITIVE_INFINITY) : 0.0;
    }

    public static double floatToDouble(float value) {
        int e = Math.getExponent(value) - 23;
        if (e >= 0) {
            return value;
        }
        int m = Numerics.getSignificand(value);
        assert (Math.scalb(m, e) == Math.abs(value)) : value;
        int e10 = -Numerics.toExp10(e);
        double c = Math.scalb(DecimalFunctions.pow10(e10), e);
        double mc = (double)m * c;
        double r = Math.rint(mc / 10.0) * 10.0;
        if (Math.abs(r - mc) >= c / 2.0) {
            r = Math.rint(mc);
        }
        r = Math.copySign(Math.scalb(r / c, e), (double)value);
        assert (value == (float)r) : value;
        return r;
    }

    public static double deltaForDoubleToDecimal(double value) {
        int e = Math.getExponent(value) - 52;
        if (e >= 0) {
            return 0.0;
        }
        if (e < -76) {
            return e == -1075 ? 0.0 : Double.NaN;
        }
        long m = Numerics.getSignificand(value);
        assert (Math.scalb((double)m, e) == Math.abs(value)) : value;
        int e10 = -Numerics.toExp10(e);
        int PRECISION = 56;
        double cs = Math.scalb(DecimalFunctions.pow10(e10 - 1), e + 56);
        long ci = (long)cs;
        long mc = m * ci & 0xFFFFFFFFFFFFFFL;
        if (mc >= 0x80000000000000L) {
            mc -= 0x100000000000000L;
        }
        if (Math.abs(mc) >= ci / 2L) {
            if ((mc %= 0x19999999999999L) >= 0L) {
                if (mc >= 0xCCCCCCCCCCCCCL) {
                    mc -= 0x19999999999999L;
                }
            } else if (mc < -3602879701896396L) {
                mc += 0x19999999999999L;
            }
        }
        double delta = MathFunctions.xorSign(-Math.scalb((double)mc / cs, e), value);
        assert (Math.abs(delta) <= Math.ulp(value) / 2.0) : value;
        return delta;
    }

    public static int fractionDigitsForDelta(double accuracy, boolean strict) {
        int i = MathFunctions.getExponent(accuracy = Math.abs(accuracy));
        if (i == 1024) {
            return 0;
        }
        if (accuracy >= DecimalFunctions.pow10((i = Numerics.toExp10(i)) + 1)) {
            ++i;
        }
        i = -i;
        if (strict) {
            double scale = DecimalFunctions.pow10(i);
            while (true) {
                double d;
                accuracy *= scale;
                if (!(d >= 9.5)) break;
                ++i;
                accuracy -= Math.floor(accuracy);
                scale = 10.0;
            }
        }
        return i;
    }

    public static int fractionDigitsForValue(double value) {
        int exponent = Math.getExponent(value);
        if (exponent <= 1023) {
            return -Numerics.toExp10(exponent - 52);
        }
        return 0;
    }

    public static int fractionDigitsForValue(double value, int uncertainDigits) {
        ArgumentChecks.ensurePositive("uncertainDigits", uncertainDigits);
        int digits = DecimalFunctions.fractionDigitsForValue(value);
        int reduced = digits - uncertainDigits;
        if (reduced > 0 && Math.rint(value *= DecimalFunctions.pow10(reduced)) % 10000.0 == 0.0) {
            return reduced;
        }
        return digits;
    }

    public static int floorLog10(double x) {
        int p;
        int i;
        if (x > 0.0 && (i = (p = Numerics.toExp10(MathFunctions.getExponent(x))) - -324) >= 0 && i < POW10.length) {
            if (POW10[i] <= x) {
                ++p;
            }
            return p;
        }
        throw new ArithmeticException(String.valueOf(x));
    }

    public static boolean equalsIgnoreMissingFractionDigits(double accurate, double approximate) {
        double delta = Math.abs(accurate - approximate);
        if (delta < 1.0) {
            int p = Numerics.toExp10(MathFunctions.getExponent(delta));
            if ((p = Math.max(p - -323, 0)) + 1 < POW10.length && POW10[p + 1] <= delta) {
                ++p;
            }
            if ((p = 645 - p) >= 0 && p < POW10.length) {
                double scale;
                assert (delta * scale >= 0.1) : delta;
                double diffInFractions = approximate * scale;
                if (Math.abs((approximate = Math.rint(diffInFractions)) - diffInFractions) <= Math.ulp(diffInFractions)) {
                    for (scale = POW10[p]; approximate % 10.0 == 0.0 && scale >= 10.0; scale /= 10.0) {
                        approximate /= 10.0;
                    }
                    return Math.abs(approximate - (accurate *= scale)) <= 0.5;
                }
            }
        }
        return Double.doubleToLongBits(accurate) == Double.doubleToLongBits(approximate);
    }

    static {
        StringBuilder buffer = new StringBuilder("1E");
        for (int i = 0; i < POW10.length; ++i) {
            buffer.setLength(2);
            buffer.append(i + -323);
            DecimalFunctions.POW10[i] = Double.parseDouble(buffer.toString());
        }
    }
}

