/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.time.temporal.Temporal;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.Builder;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.datum.DatumOrEnsemble;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.EllipsoidalHeightCombiner;
import org.apache.sis.referencing.internal.shared.ReferencingFactoryContainer;
import org.apache.sis.referencing.operation.provider.PolarStereographicA;
import org.apache.sis.referencing.operation.provider.TransverseMercator;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.temporal.TemporalDate;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.FactoryException;

public class GeodeticObjectBuilder
extends Builder<GeodeticObjectBuilder> {
    private GeodeticDatum datum;
    private String conversionName;
    private OperationMethod method;
    private ParameterValueGroup parameters;
    private final ReferencingFactoryContainer factories;
    private final Locale locale;
    private boolean normalizedAxisOrder;

    public GeodeticObjectBuilder() {
        this(null, null);
    }

    public GeodeticObjectBuilder(ReferencingFactoryContainer factories, Locale locale) {
        this.factories = factories != null ? factories : new ReferencingFactoryContainer();
        this.locale = locale;
    }

    private static Map<String, Object> name(IdentifiedObject template) {
        return Map.of("name", template.getName());
    }

    public GeodeticObjectBuilder setNormalizedAxisOrder(boolean normalized) {
        this.normalizedAxisOrder = normalized;
        return this;
    }

    public GeodeticObjectBuilder setDomainOfValidity(CharSequence description, double westBoundLongitude, double eastBoundLongitude, double southBoundLatitude, double northBoundLatitude) {
        DefaultGeographicBoundingBox bbox = new DefaultGeographicBoundingBox(westBoundLongitude, eastBoundLongitude, southBoundLatitude, northBoundLatitude);
        if (bbox.isEmpty()) {
            bbox = null;
        }
        if (description != null || bbox != null) {
            DefaultExtent extent = new DefaultExtent(description, (GeographicExtent)bbox, null, null);
            this.properties.put("domainOfValidity", extent);
        }
        return this;
    }

    public GeodeticObjectBuilder setFlattenedSphere(String name, double semiMajorAxis, double inverseFlattening, Unit<Length> units) throws FactoryException {
        DatumFactory factory = this.factories.getDatumFactory();
        Ellipsoid ellipsoid = factory.createFlattenedSphere(Map.of("name", name), semiMajorAxis, inverseFlattening, units);
        this.datum = factory.createGeodeticDatum(GeodeticObjectBuilder.name((IdentifiedObject)ellipsoid), ellipsoid, CommonCRS.WGS84.primeMeridian());
        return this;
    }

    public GeodeticObjectBuilder setConversionMethod(String name) throws FactoryException {
        if (this.method != null) {
            throw new IllegalStateException(Errors.forLocale((Locale)this.locale).getString((short)42, (Object)"OperationMethod"));
        }
        this.method = this.factories.findOperationMethod(name);
        this.parameters = this.method.getParameters().createValue();
        return this;
    }

    public GeodeticObjectBuilder setConversionName(String name) {
        this.conversionName = name;
        return this;
    }

    public GeodeticObjectBuilder setConversion(MathTransformBuilder builder) throws FactoryException {
        this.method = builder.getMethod().orElseThrow(() -> new FactoryException());
        this.parameters = builder.parameters();
        return this;
    }

    private void ensureConversionMethodSet() {
        if (this.parameters == null) {
            throw new IllegalStateException(Resources.forLocale(this.locale).getString((short)70));
        }
    }

    public GeodeticObjectBuilder setParameter(String name, double value, Unit<?> unit) throws IllegalStateException, ParameterNotFoundException, InvalidParameterValueException {
        this.ensureConversionMethodSet();
        this.parameters.parameter(name).setValue(value, unit);
        return this;
    }

    public GeodeticObjectBuilder changeConversion(String newMethod, BiConsumer<ParameterValue<?>, Parameters> mapper) throws FactoryException {
        this.ensureConversionMethodSet();
        if (mapper == null) {
            mapper = GeodeticObjectBuilder::copyParameterValue;
        }
        ParameterValueGroup source = this.parameters;
        if (newMethod != null) {
            this.method = null;
            this.setConversionMethod(newMethod);
        }
        Parameters target = Parameters.castOrWrap(this.parameters);
        for (GeneralParameterValue param : source.values()) {
            mapper.accept((ParameterValue)param, target);
        }
        return this;
    }

    private static void copyParameterValue(ParameterValue<?> source, Parameters target) {
        target.getOrCreate(source.getDescriptor()).setValue(source.getValue());
    }

    public GeodeticObjectBuilder apply(ProjectedCRS crs) {
        Projection c = crs.getConversionFromBase();
        this.conversionName = c.getName().getCode();
        this.method = c.getMethod();
        this.parameters = c.getParameterValues();
        this.datum = DatumOrEnsemble.asDatum((GeodeticCRS)crs.getBaseCRS());
        this.properties.putAll(IdentifiedObjects.getProperties((IdentifiedObject)crs, "identifiers"));
        return this;
    }

    public GeodeticObjectBuilder applyTransverseMercator(TransverseMercator.Zoner zoner, double latitude, double longitude) throws FactoryException {
        ArgumentChecks.ensureBetween((String)"latitude", (double)-90.0, (double)90.0, (double)latitude);
        ArgumentChecks.ensureBetween((String)"longitude", (double)-4.052915431398935E8, (double)4.052915431398935E8, (double)longitude);
        this.setConversionMethod("Transverse Mercator");
        this.setConversionName(zoner.setParameters(this.parameters, latitude, longitude));
        return this;
    }

    public GeodeticObjectBuilder applyPolarStereographic(boolean north) throws FactoryException {
        this.setConversionMethod("Polar Stereographic (variant A)");
        this.setConversionName(PolarStereographicA.setParameters(this.parameters, north));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS createProjectedCRS(GeographicCRS baseCRS, CartesianCS derivedCS) throws FactoryException {
        this.ensureConversionMethodSet();
        this.onCreate(false);
        try {
            String name = this.conversionName != null ? this.properties.put("name", this.conversionName) : null;
            Object alias = this.properties.put("alias", null);
            Object identifier = this.properties.put("identifiers", null);
            Conversion conversion = this.factories.getCoordinateOperationFactory().createDefiningConversion(this.properties, this.method, this.parameters);
            this.properties.put("identifiers", identifier);
            this.properties.put("alias", alias);
            if (name != null) {
                this.properties.put("name", name);
            }
            if (derivedCS == null) {
                derivedCS = this.factories.getStandardProjectedCS();
            }
            ProjectedCRS projectedCRS = this.factories.getCRSFactory().createProjectedCRS(this.properties, baseCRS, conversion, derivedCS);
            return projectedCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public ProjectedCRS createProjectedCRS() throws FactoryException {
        GeographicCRS crs = this.getBaseCRS();
        IdentifiedObject id = this.getDatumOrEnsemble();
        if (id != null) {
            crs = this.factories.getCRSFactory().createGeographicCRS(GeodeticObjectBuilder.name(id), this.datum, crs.getCoordinateSystem());
        }
        return this.createProjectedCRS(crs, this.factories.getStandardProjectedCS());
    }

    private IdentifiedObject getDatumOrEnsemble() {
        return this.datum;
    }

    private GeographicCRS getBaseCRS() {
        return this.normalizedAxisOrder ? CommonCRS.defaultGeographic() : CommonCRS.WGS84.geographic();
    }

    public GeographicCRS createGeographicCRS() throws FactoryException {
        GeographicCRS crs = this.getBaseCRS();
        IdentifiedObject id = this.getDatumOrEnsemble();
        if (id != null) {
            this.properties.putIfAbsent("name", id.getName());
        }
        return this.factories.getCRSFactory().createGeographicCRS(this.properties, this.datum, crs.getCoordinateSystem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalCRS createTemporalCRS(Temporal origin, Unit<Time> unit) throws FactoryException {
        TimeCS cs = null;
        TemporalDatum td = null;
        for (CommonCRS.Temporal c : CommonCRS.Temporal.values()) {
            TemporalCRS crs;
            TimeCS candidate;
            TemporalDatum candidate2;
            if (td == null && origin.equals((candidate2 = c.datum()).getOrigin())) {
                td = candidate2;
            }
            if (cs != null || !unit.equals((Object)(candidate = (crs = c.crs()).getCoordinateSystem()).getAxis(0).getUnit())) continue;
            if (td == candidate && this.properties.isEmpty()) {
                return crs;
            }
            cs = candidate;
        }
        this.onCreate(false);
        try {
            if (cs == null) {
                CSFactory csFactory = this.factories.getCSFactory();
                cs = CommonCRS.Temporal.JAVA.crs().getCoordinateSystem();
                cs = csFactory.createTimeCS(GeodeticObjectBuilder.name((IdentifiedObject)cs), csFactory.createCoordinateSystemAxis(GeodeticObjectBuilder.name((IdentifiedObject)cs.getAxis(0)), "t", AxisDirection.FUTURE, unit));
            }
            if (this.properties.get("name") == null) {
                this.properties.putAll(GeodeticObjectBuilder.name((IdentifiedObject)cs));
            }
            if (td == null) {
                Object remarks = this.properties.remove("remarks");
                Object identifier = this.properties.remove("identifiers");
                td = this.factories.getDatumFactory().createTemporalDatum(this.properties, TemporalDate.toDate((Temporal)origin));
                this.properties.put("identifiers", identifier);
                this.properties.put("remarks", remarks);
                this.properties.put("name", td.getName());
            }
            TemporalCRS temporalCRS = this.factories.getCRSFactory().createTemporalCRS(this.properties, td, cs);
            return temporalCRS;
        }
        finally {
            this.onCreate(true);
        }
    }

    public CoordinateReferenceSystem createCompoundCRS(CoordinateReferenceSystem ... components) throws FactoryException {
        return new EllipsoidalHeightCombiner(this.factories).createCompoundCRS(this.properties, components);
    }

    public CoordinateReferenceSystem replaceComponent(CoordinateReferenceSystem source, int firstDimension, CoordinateReferenceSystem replacement) throws FactoryException {
        int srcDim = CRS.getDimensionOrZero(source);
        int repDim = CRS.getDimensionOrZero(replacement);
        if (firstDimension == 0 && srcDim == repDim) {
            return source.equals((Object)replacement) ? source : replacement;
        }
        Objects.checkIndex(firstDimension, srcDim - repDim);
        if (source instanceof CompoundCRS) {
            CoordinateReferenceSystem[] components = (CoordinateReferenceSystem[])((CompoundCRS)source).getComponents().toArray(CoordinateReferenceSystem[]::new);
            int lower = 0;
            for (int i = 0; i < components.length; ++i) {
                CoordinateReferenceSystem c = components[i];
                if (firstDimension >= lower) {
                    Object name = this.properties.remove("name");
                    Object alias = this.properties.remove("alias");
                    Object ids = this.properties.remove("identifiers");
                    CoordinateReferenceSystem nc = this.replaceComponent(c, firstDimension - lower, replacement);
                    if (name == null) {
                        name = source.getName();
                    }
                    this.properties.put("name", name);
                    this.properties.put("alias", alias);
                    this.properties.put("identifiers", ids);
                    if (nc == c) {
                        return source;
                    }
                    components[i] = nc;
                    return this.createCompoundCRS(components);
                }
                lower += CRS.getDimensionOrZero(c);
            }
        }
        throw new IllegalArgumentException(Resources.forLocale(this.locale).getString((short)84, IdentifiedObjects.getDisplayName((IdentifiedObject)source, this.locale)));
    }
}

