/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.mysql.resultset;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.shardingsphere.database.connector.core.resultset.DialectResultSetMapper;

public final class MySQLResultSetMapper
implements DialectResultSetMapper {
    private static final String YEAR_DATA_TYPE = "YEAR";

    public Object getSmallintValue(ResultSet resultSet, int columnIndex) throws SQLException {
        return resultSet.getInt(columnIndex);
    }

    public Object getDateValue(ResultSet resultSet, int columnIndex) throws SQLException {
        if (MySQLResultSetMapper.isYearDataType(resultSet.getMetaData().getColumnTypeName(columnIndex))) {
            return resultSet.wasNull() ? null : resultSet.getObject(columnIndex);
        }
        return resultSet.getDate(columnIndex);
    }

    private static boolean isYearDataType(String columnDataTypeName) {
        return YEAR_DATA_TYPE.equalsIgnoreCase(columnDataTypeName);
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

