/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.connector.mysql.metadata.database.option;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DefaultDataTypeOption;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.datatype.DialectDataTypeOption;

public final class MySQLDataTypeOption
implements DialectDataTypeOption {
    private static final Map<String, Integer> EXTRA_DATA_TYPES = MySQLDataTypeOption.setUpExtraDataTypes();
    private final DialectDataTypeOption delegate = new DefaultDataTypeOption();

    private static Map<String, Integer> setUpExtraDataTypes() {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        result.put("JSON", -1);
        result.put("GEOMETRY", -2);
        result.put("GEOMETRYCOLLECTION", -2);
        result.put("YEAR", 91);
        result.put("POINT", -2);
        result.put("MULTIPOINT", -2);
        result.put("POLYGON", -2);
        result.put("MULTIPOLYGON", -2);
        result.put("LINESTRING", -2);
        result.put("MULTILINESTRING", -2);
        return result;
    }

    public Map<String, Integer> getExtraDataTypes() {
        return EXTRA_DATA_TYPES;
    }

    public Optional<Class<?>> findExtraSQLTypeClass(int dataType, boolean unsigned) {
        if (-6 == dataType || 5 == dataType) {
            return Optional.of(Integer.class);
        }
        if (4 == dataType) {
            return unsigned ? Optional.of(Long.class) : Optional.of(Integer.class);
        }
        if (-5 == dataType) {
            return unsigned ? Optional.of(BigInteger.class) : Optional.of(Long.class);
        }
        return Optional.empty();
    }

    public boolean isIntegerDataType(int sqlType) {
        return this.delegate.isIntegerDataType(sqlType);
    }

    public boolean isStringDataType(int sqlType) {
        return this.delegate.isStringDataType(sqlType);
    }

    public boolean isBinaryDataType(int sqlType) {
        return this.delegate.isBinaryDataType(sqlType);
    }
}

