/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.persist.config.database;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.database.metadata.datasource.StorageUnitNodePath;
import org.apache.shardingsphere.mode.node.path.version.VersionNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class DataSourceUnitPersistService {
    private final PersistRepository repository;
    private final VersionPersistService versionPersistService;
    private final YamlDataSourceConfigurationSwapper yamlDataSourceConfigurationSwapper;

    public DataSourceUnitPersistService(PersistRepository repository) {
        this.repository = repository;
        this.versionPersistService = new VersionPersistService(repository);
        this.yamlDataSourceConfigurationSwapper = new YamlDataSourceConfigurationSwapper();
    }

    public Map<String, DataSourcePoolProperties> load(String databaseName) {
        List childrenKeys = this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new StorageUnitNodePath(databaseName, null)));
        LinkedHashMap<String, DataSourcePoolProperties> result = new LinkedHashMap<String, DataSourcePoolProperties>(childrenKeys.size(), 1.0f);
        for (String each : childrenKeys) {
            this.load(databaseName, each).ifPresent(dataSourcePoolProps -> result.put(each, (DataSourcePoolProperties)dataSourcePoolProps));
        }
        return result;
    }

    public Optional<DataSourcePoolProperties> load(String databaseName, String dataSourceName) {
        VersionNodePath versionNodePath = new VersionNodePath((NodePath)new StorageUnitNodePath(databaseName, dataSourceName));
        String activeVersion = this.repository.query(versionNodePath.getActiveVersionPath());
        if (Strings.isNullOrEmpty((String)activeVersion)) {
            return Optional.empty();
        }
        String dataSourceContent = this.repository.query(versionNodePath.getVersionPath(Integer.parseInt(activeVersion)));
        if (Strings.isNullOrEmpty((String)dataSourceContent)) {
            return Optional.empty();
        }
        return Optional.of(this.yamlDataSourceConfigurationSwapper.swapToDataSourcePoolProperties((Map)YamlEngine.unmarshal((String)dataSourceContent, Map.class)));
    }

    public void persist(String databaseName, Map<String, DataSourcePoolProperties> dataSourcePropsMap) {
        for (Map.Entry<String, DataSourcePoolProperties> entry : dataSourcePropsMap.entrySet()) {
            VersionNodePath versionNodePath = new VersionNodePath((NodePath)new StorageUnitNodePath(databaseName, entry.getKey()));
            this.versionPersistService.persist(versionNodePath, YamlEngine.marshal((Object)this.yamlDataSourceConfigurationSwapper.swapToMap(entry.getValue())));
        }
    }

    public void delete(String databaseName, String dataSourceName) {
        this.repository.delete(NodePathGenerator.toPath((NodePath)new StorageUnitNodePath(databaseName, dataSourceName)));
    }
}

