/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.factory.init.type;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.database.impl.DataSourceGeneratedDatabaseConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationProperties;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.database.DatabaseTypeEngine;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabasesFactory;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.mode.manager.builder.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.init.MetaDataContextsInitFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.metadata.persist.config.global.PropertiesPersistService;
import org.apache.shardingsphere.mode.metadata.persist.version.VersionPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterCenterMetaDataContextsInitFactory
extends MetaDataContextsInitFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegisterCenterMetaDataContextsInitFactory.class);
    private final MetaDataPersistFacade persistFacade;
    private final ComputeNodeInstanceContext instanceContext;
    private final boolean persistSchemasEnabled;

    public RegisterCenterMetaDataContextsInitFactory(PersistRepository repository, ComputeNodeInstanceContext instanceContext) {
        this.persistSchemasEnabled = (Boolean)new ConfigurationProperties(new PropertiesPersistService(repository, new VersionPersistService(repository)).load()).getValue((Enum)ConfigurationPropertyKey.PERSIST_SCHEMAS_TO_REPOSITORY_ENABLED);
        this.persistFacade = new MetaDataPersistFacade(repository, this.persistSchemasEnabled);
        this.instanceContext = instanceContext;
    }

    @Override
    public MetaDataContexts create(ContextManagerBuilderParameter param) throws SQLException {
        Collection databases;
        TemporaryConfigurationProperties tempProps = new TemporaryConfigurationProperties(this.persistFacade.getPropsService().load());
        boolean isInstanceConnectionEnabled = (Boolean)tempProps.getValue((Enum)TemporaryConfigurationPropertyKey.INSTANCE_CONNECTION_ENABLED);
        Map<String, DatabaseConfiguration> effectiveDatabaseConfigs = this.createEffectiveDatabaseConfigurations(this.getDatabaseNames(param.getDatabaseConfigs()), param.getDatabaseConfigs(), isInstanceConnectionEnabled);
        Map<String, DataSource> globalDataSources = param.getGlobalDataSources();
        ConfigurationProperties props = new ConfigurationProperties(this.persistFacade.getPropsService().load());
        DatabaseType protocolType = DatabaseTypeEngine.getProtocolType(effectiveDatabaseConfigs, (ConfigurationProperties)props);
        Map<String, Collection<ShardingSphereSchema>> schemas = this.loadSchemas(effectiveDatabaseConfigs.keySet(), protocolType);
        if (this.persistSchemasEnabled) {
            databases = ShardingSphereDatabasesFactory.create(effectiveDatabaseConfigs, schemas, (ConfigurationProperties)props, (ComputeNodeInstanceContext)this.instanceContext, (DatabaseType)protocolType);
        } else {
            databases = ShardingSphereDatabasesFactory.create(effectiveDatabaseConfigs, (ConfigurationProperties)props, (ComputeNodeInstanceContext)this.instanceContext, (DatabaseType)protocolType);
            databases.stream().filter(database -> schemas.containsKey(database.getName())).forEach(database -> ((Collection)schemas.get(database.getName())).stream().filter(schema -> database.containsSchema(schema.getName())).forEach(schema -> {
                ShardingSphereSchema targetSchema = database.getSchema(schema.getName());
                schema.getAllViews().forEach(arg_0 -> ((ShardingSphereSchema)targetSchema).putView(arg_0));
            }));
        }
        return this.create(this.persistFacade.getGlobalRuleService().load(), globalDataSources, databases, props, this.persistFacade);
    }

    private Collection<String> getDatabaseNames(Map<String, DatabaseConfiguration> databaseConfigs) {
        return this.instanceContext.getInstance().getMetaData() instanceof JDBCInstanceMetaData ? databaseConfigs.keySet() : this.persistFacade.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames();
    }

    private Map<String, DatabaseConfiguration> createEffectiveDatabaseConfigurations(Collection<String> databaseNames, Map<String, DatabaseConfiguration> databaseConfigs, boolean isInstanceConnectionEnabled) {
        return databaseNames.stream().collect(Collectors.toMap(each -> each, each -> this.createEffectiveDatabaseConfiguration((String)each, databaseConfigs, isInstanceConnectionEnabled)));
    }

    private DatabaseConfiguration createEffectiveDatabaseConfiguration(String databaseName, Map<String, DatabaseConfiguration> databaseConfigs, boolean isInstanceConnectionEnabled) {
        this.closeGeneratedDataSources(databaseName, databaseConfigs);
        Map<String, DataSourceConfiguration> dataSources = this.persistFacade.loadDataSourceConfigurations(databaseName);
        Collection<RuleConfiguration> databaseRuleConfigs = this.persistFacade.getDatabaseRuleService().load(databaseName);
        return new DataSourceGeneratedDatabaseConfiguration(dataSources, databaseRuleConfigs, isInstanceConnectionEnabled);
    }

    private void closeGeneratedDataSources(String databaseName, Map<String, ? extends DatabaseConfiguration> databaseConfigs) {
        if (databaseConfigs.containsKey(databaseName) && !databaseConfigs.get(databaseName).getStorageUnits().isEmpty()) {
            databaseConfigs.get(databaseName).getDataSources().values().forEach(each -> new DataSourcePoolDestroyer(each).asyncDestroy());
        }
    }

    private Map<String, Collection<ShardingSphereSchema>> loadSchemas(Collection<String> databaseNames, DatabaseType protocolType) {
        HashMap<String, Collection<ShardingSphereSchema>> result = new HashMap<String, Collection<ShardingSphereSchema>>(databaseNames.size());
        for (String dbName : databaseNames) {
            Collection<ShardingSphereSchema> schemas = this.persistFacade.getDatabaseMetaDataFacade().getSchema().load(dbName, protocolType);
            if (schemas == null) continue;
            result.put(dbName, schemas);
        }
        return result;
    }
}

