/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.check.consistency;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.ConsistencyCheckJobItemProgressContext;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineCancellable;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.position.TableCheckRangePosition;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyChecker;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableDataConsistencyCheckerFactory;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionProcessContext;
import org.apache.shardingsphere.data.pipeline.core.datanode.DataNodeUtils;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeEntry;
import org.apache.shardingsphere.data.pipeline.core.datanode.JobDataNodeLine;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.data.PipelineTableDataConsistencyCheckLoadingFailedException;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.UniqueKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.job.config.PipelineJobConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.job.service.TransmissionJobManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.StandardPipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.core.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.data.pipeline.core.util.PipelineDataSourceConfigurationUtils;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationDataConsistencyChecker
implements PipelineDataConsistencyChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationDataConsistencyChecker.class);
    private final MigrationJobConfiguration jobConfig;
    private final JobRateLimitAlgorithm readRateLimitAlgorithm;
    private final ConsistencyCheckJobItemProgressContext progressContext;
    private final AtomicReference<TableInventoryChecker> currentTableInventoryChecker = new AtomicReference();
    private final AtomicBoolean canceling = new AtomicBoolean(false);

    public MigrationDataConsistencyChecker(MigrationJobConfiguration jobConfig, TransmissionProcessContext processContext, ConsistencyCheckJobItemProgressContext progressContext) {
        this.jobConfig = jobConfig;
        this.readRateLimitAlgorithm = processContext.getReadRateLimitAlgorithm();
        this.progressContext = progressContext;
    }

    public Map<String, TableDataConsistencyCheckResult> check(String algorithmType, Properties algorithmProps) {
        LinkedList sourceTableNames = new LinkedList();
        this.jobConfig.getJobShardingDataNodes().forEach(each -> each.getEntries().forEach(entry -> entry.getDataNodes().forEach(dataNode -> sourceTableNames.add(new QualifiedTable(dataNode.getSchemaName(), dataNode.getTableName()).format()))));
        this.progressContext.setRecordsCount(this.getRecordsCount());
        this.progressContext.getTableNames().addAll(sourceTableNames);
        this.progressContext.onProgressUpdated(new PipelineJobUpdateProgress(0));
        LinkedHashMap<QualifiedTable, TableDataConsistencyCheckResult> checkResultMap = new LinkedHashMap<QualifiedTable, TableDataConsistencyCheckResult>();
        try (PipelineDataSourceManager dataSourceManager = new PipelineDataSourceManager();
             TableDataConsistencyChecker tableChecker = TableDataConsistencyCheckerFactory.newInstance((String)algorithmType, (Properties)algorithmProps);){
            PipelineDataSourceConfigurationUtils.transformPipelineDataSourceConfiguration((String)this.jobConfig.getJobId(), (ShardingSpherePipelineDataSourceConfiguration)((ShardingSpherePipelineDataSourceConfiguration)this.jobConfig.getTarget()));
            if (this.progressContext.getTableCheckRangePositions().isEmpty()) {
                this.progressContext.getTableCheckRangePositions().addAll(this.splitCrossTables());
            }
            Iterator iterator = this.progressContext.getTableCheckRangePositions().iterator();
            while (true) {
                if (iterator.hasNext()) {
                    TableCheckRangePosition each2 = (TableCheckRangePosition)iterator.next();
                    TableDataConsistencyCheckResult checkResult = this.checkSingleTableInventoryData(each2, tableChecker, dataSourceManager);
                    log.info("checkResult: {}, table: {}, checkRangePosition: {}", new Object[]{checkResult, each2.getSourceDataNode(), each2});
                    DataNode dataNode = DataNodeUtils.parseWithSchema((String)each2.getSourceDataNode());
                    QualifiedTable sourceTable = new QualifiedTable(dataNode.getSchemaName(), dataNode.getTableName());
                    checkResultMap.put(sourceTable, checkResult);
                    if (checkResult.isIgnored()) {
                        this.progressContext.getIgnoredTableNames().add(sourceTable.format());
                        log.info("Table '{}' is ignored, ignore type: {}", (Object)each2.getSourceDataNode(), (Object)checkResult.getIgnoredType());
                        continue;
                    }
                    if (checkResult.isMatched() || !tableChecker.isBreakOnInventoryCheckNotMatched()) continue;
                    log.info("Unmatched on table '{}', ignore left tables", (Object)each2.getSourceDataNode());
                    this.cancel();
                    Map<String, TableDataConsistencyCheckResult> map = checkResultMap.entrySet().stream().collect(Collectors.toMap(entry -> ((QualifiedTable)entry.getKey()).toString(), Map.Entry::getValue));
                    return map;
                    continue;
                }
                break;
            }
        }
        log.info("check done, jobId={}", (Object)this.jobConfig.getJobId());
        return checkResultMap.entrySet().stream().collect(Collectors.toMap(entry -> ((QualifiedTable)entry.getKey()).format(), Map.Entry::getValue));
    }

    private long getRecordsCount() {
        Map jobProgress = new TransmissionJobManager((PipelineJobType)new MigrationJobType()).getJobProgress((PipelineJobConfiguration)this.jobConfig);
        return jobProgress.values().stream().filter(Objects::nonNull).mapToLong(TransmissionJobItemProgress::getInventoryRecordsCount).sum();
    }

    private List<TableCheckRangePosition> splitCrossTables() {
        LinkedList<TableCheckRangePosition> result = new LinkedList<TableCheckRangePosition>();
        int splittingItem = 0;
        for (JobDataNodeLine each : this.jobConfig.getJobShardingDataNodes()) {
            for (JobDataNodeEntry entry : each.getEntries()) {
                for (DataNode dataNode : entry.getDataNodes()) {
                    result.add(new TableCheckRangePosition(Integer.valueOf(splittingItem++), dataNode.format(), entry.getLogicTableName(), UniqueKeyIngestPosition.ofUnsplit(), UniqueKeyIngestPosition.ofUnsplit(), null));
                }
            }
        }
        return result;
    }

    private TableDataConsistencyCheckResult checkSingleTableInventoryData(TableCheckRangePosition checkRangePosition, TableDataConsistencyChecker tableChecker, PipelineDataSourceManager dataSourceManager) {
        log.info("checkSingleTableInventoryData, jobId: {}, checkRangePosition: {}", (Object)this.jobConfig.getJobId(), (Object)checkRangePosition);
        DataNode dataNode = DataNodeUtils.parseWithSchema((String)checkRangePosition.getSourceDataNode());
        QualifiedTable sourceTable = new QualifiedTable(dataNode.getSchemaName(), dataNode.getTableName());
        PipelineDataSource sourceDataSource = dataSourceManager.getDataSource(this.jobConfig.getSources().get(dataNode.getDataSourceName()));
        StandardPipelineTableMetaDataLoader metaDataLoader = new StandardPipelineTableMetaDataLoader(sourceDataSource);
        PipelineTableMetaData tableMetaData = metaDataLoader.getTableMetaData(dataNode.getSchemaName(), dataNode.getTableName());
        ShardingSpherePreconditions.checkNotNull((Object)tableMetaData, () -> new PipelineTableDataConsistencyCheckLoadingFailedException(new QualifiedTable(dataNode.getSchemaName(), dataNode.getTableName())));
        String targetTableName = checkRangePosition.getLogicTableName();
        List columnNames = tableMetaData.getColumnNames();
        List uniqueKeys = PipelineTableMetaDataUtils.getUniqueKeyColumns((String)sourceTable.getSchemaName(), (String)sourceTable.getTableName(), (PipelineTableMetaDataLoader)metaDataLoader);
        QualifiedTable targetTable = new QualifiedTable(dataNode.getSchemaName(), targetTableName);
        PipelineDataSource targetDataSource = dataSourceManager.getDataSource(this.jobConfig.getTarget());
        TableInventoryCheckParameter param = new TableInventoryCheckParameter(this.jobConfig.getJobId(), checkRangePosition.getSplittingItem().intValue(), sourceDataSource, targetDataSource, sourceTable, targetTable, columnNames, uniqueKeys, this.readRateLimitAlgorithm, this.progressContext, checkRangePosition.getQueryCondition());
        TableInventoryChecker tableInventoryChecker = tableChecker.buildTableInventoryChecker(param);
        this.currentTableInventoryChecker.set(tableInventoryChecker);
        Optional preCheckResult = tableInventoryChecker.preCheck();
        TableDataConsistencyCheckResult result = preCheckResult.orElseGet(() -> ((TableInventoryChecker)tableInventoryChecker).checkSingleTableInventoryData());
        tableInventoryChecker.cancel();
        this.currentTableInventoryChecker.set(null);
        return result;
    }

    public void cancel() {
        this.canceling.set(true);
        Optional.ofNullable(this.currentTableInventoryChecker.get()).ifPresent(PipelineCancellable::cancel);
        this.currentTableInventoryChecker.set(null);
    }

    public boolean isCanceling() {
        return this.canceling.get();
    }
}

