/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.type.DatabaseRuleAlterExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.InUsedAlgorithmException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.rule.MissingRequiredRuleException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.handler.checker.ShadowRuleStatementChecker;
import org.apache.shardingsphere.shadow.distsql.handler.converter.ShadowRuleStatementConverter;
import org.apache.shardingsphere.shadow.distsql.handler.supporter.ShadowRuleStatementSupporter;
import org.apache.shardingsphere.shadow.distsql.handler.update.UnusedAlgorithmFinder;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowAlgorithmSegment;
import org.apache.shardingsphere.shadow.distsql.segment.ShadowRuleSegment;
import org.apache.shardingsphere.shadow.distsql.statement.AlterShadowRuleStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;

@DistSQLExecutorCurrentRuleRequired(value=ShadowRule.class)
public final class AlterShadowRuleExecutor
implements DatabaseRuleAlterExecutor<AlterShadowRuleStatement, ShadowRule, ShadowRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(AlterShadowRuleStatement sqlStatement) {
        this.checkRuleNames(sqlStatement.getRules());
        ShadowRuleStatementChecker.checkStorageUnitsExist(ShadowRuleStatementSupporter.getStorageUnitNames(sqlStatement.getRules()), this.database);
        this.checkAlgorithms(sqlStatement.getRules());
        this.checkAlgorithmType(sqlStatement);
    }

    private void checkRuleNames(Collection<ShadowRuleSegment> segments) {
        List<String> currentRuleNames = ShadowRuleStatementSupporter.getRuleNames(this.rule.getConfiguration());
        List<String> requiredRuleNames = ShadowRuleStatementSupporter.getRuleNames(segments);
        ShadowRuleStatementChecker.checkDuplicated(requiredRuleNames, duplicated -> new DuplicateRuleException("shadow", this.database.getName(), duplicated));
        ShadowRuleStatementChecker.checkExisted(requiredRuleNames, currentRuleNames, notExistedRules -> new MissingRequiredRuleException("Shadow", notExistedRules));
    }

    private void checkAlgorithms(Collection<ShadowRuleSegment> segments) {
        List<String> requiredAlgorithms = ShadowRuleStatementSupporter.getAlgorithmNames(segments);
        ShadowRuleStatementChecker.checkDuplicated(requiredAlgorithms, duplicated -> new InUsedAlgorithmException("Shadow", this.database.getName(), duplicated));
    }

    private void checkAlgorithmType(AlterShadowRuleStatement sqlStatement) {
        sqlStatement.getRules().stream().flatMap(each -> each.getShadowTableRules().values().stream()).flatMap(Collection::stream).map(ShadowAlgorithmSegment::getAlgorithmSegment).forEach(each -> TypedSPILoader.checkService(ShadowAlgorithm.class, (Object)each.getName(), (Properties)each.getProps()));
    }

    public ShadowRuleConfiguration buildToBeAlteredRuleConfiguration(AlterShadowRuleStatement sqlStatement) {
        return ShadowRuleStatementConverter.convert(sqlStatement.getRules());
    }

    public ShadowRuleConfiguration buildToBeDroppedRuleConfiguration(ShadowRuleConfiguration toBeAlteredRuleConfig) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        UnusedAlgorithmFinder.findUnusedShadowAlgorithm(this.rule.getConfiguration()).forEach(each -> result.getShadowAlgorithms().put(each, (AlgorithmConfiguration)this.rule.getConfiguration().getShadowAlgorithms().get(each)));
        return result;
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<AlterShadowRuleStatement> getType() {
        return AlterShadowRuleStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

