/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDataSourceConfigurationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDataSourceConfigurationUtils.class);

    public static void transformPipelineDataSourceConfiguration(String jobId, ShardingSpherePipelineDataSourceConfiguration pipelineDataSourceConfig) {
        ShardingSphereDatabase database;
        YamlRootConfiguration rootConfig = pipelineDataSourceConfig.getRootConfig();
        try {
            database = PipelineContextManager.getProxyContext().getDatabase(rootConfig.getDatabaseName());
        }
        catch (RuntimeException ignored) {
            return;
        }
        Map storageUnitMap = database.getResourceMetaData().getStorageUnits();
        for (Map.Entry entry : rootConfig.getDataSources().entrySet()) {
            StorageUnit storageUnit = (StorageUnit)storageUnitMap.get(entry.getKey());
            if (null == storageUnit) continue;
            Map jobDataSourceProps = (Map)entry.getValue();
            Map storageUnitStandardProps = storageUnit.getDataSourcePoolProperties().getPoolPropertySynonyms().getStandardProperties();
            if (storageUnitStandardProps.containsKey("maxPoolSize")) {
                log.info("Transform maxPoolSize from '{}' to '{}' for {} data source: {}", new Object[]{jobDataSourceProps.get("maxPoolSize"), storageUnitStandardProps.get("maxPoolSize"), jobId, entry.getKey()});
                jobDataSourceProps.put("maxPoolSize", storageUnitStandardProps.get("maxPoolSize"));
            }
            if (!storageUnitStandardProps.containsKey("maximumPoolSize")) continue;
            log.info("Transform maximumPoolSize from '{}' to '{}' for {} data source: {}", new Object[]{jobDataSourceProps.get("maximumPoolSize"), storageUnitStandardProps.get("maximumPoolSize"), jobId, entry.getKey()});
            jobDataSourceProps.put("maximumPoolSize", storageUnitStandardProps.get("maximumPoolSize"));
        }
    }
}

