/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.preparer.incremental;

import java.sql.SQLException;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.ShardingSpherePipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIncrementalPositionManager;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncrementalTaskPositionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IncrementalTaskPositionManager.class);
    private final DatabaseType databaseType;
    private final DialectIncrementalPositionManager dialectPositionManager;

    public IncrementalTaskPositionManager(DatabaseType databaseType) {
        this.databaseType = databaseType;
        this.dialectPositionManager = (DialectIncrementalPositionManager)DatabaseTypedSPILoader.getService(DialectIncrementalPositionManager.class, (DatabaseType)databaseType);
    }

    public IngestPosition getPosition(JobItemIncrementalTasksProgress initialProgress, IncrementalDumperContext dumperContext, PipelineDataSourceManager dataSourceManager) throws SQLException {
        Optional<IngestPosition> position;
        if (null != initialProgress && (position = initialProgress.getIncrementalPosition()).isPresent()) {
            return position.get();
        }
        return this.dialectPositionManager.init(dataSourceManager.getDataSource(dumperContext.getCommonContext().getDataSourceConfig()), dumperContext.getJobId());
    }

    public void destroyPosition(String jobId, PipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        long startTimeMillis = System.currentTimeMillis();
        log.info("Cleanup position, database type: {}, pipeline data source type: {}", (Object)this.databaseType.getType(), (Object)pipelineDataSourceConfig.getType());
        if (pipelineDataSourceConfig instanceof ShardingSpherePipelineDataSourceConfiguration) {
            this.destroyPosition(jobId, (ShardingSpherePipelineDataSourceConfiguration)pipelineDataSourceConfig);
        } else if (pipelineDataSourceConfig instanceof StandardPipelineDataSourceConfiguration) {
            this.destroyPosition(jobId, (StandardPipelineDataSourceConfiguration)pipelineDataSourceConfig);
        }
        log.info("Destroy position cost {} ms.", (Object)(System.currentTimeMillis() - startTimeMillis));
    }

    private void destroyPosition(String jobId, ShardingSpherePipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        for (DataSourcePoolProperties each : new YamlDataSourceConfigurationSwapper().getDataSourcePoolPropertiesMap(pipelineDataSourceConfig.getRootConfig()).values()) {
            try (PipelineDataSource dataSource = new PipelineDataSource(DataSourcePoolCreator.create((DataSourcePoolProperties)each), this.databaseType);){
                this.dialectPositionManager.destroy(dataSource, jobId);
            }
        }
    }

    private void destroyPosition(String jobId, StandardPipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        try (PipelineDataSource dataSource = new PipelineDataSource(DataSourcePoolCreator.create((DataSourcePoolProperties)((DataSourcePoolProperties)pipelineDataSourceConfig.getDataSourceConfiguration())), this.databaseType);){
            this.dialectPositionManager.destroy(dataSource, jobId);
        }
    }
}

