/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.PipelineCancellable;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.position.TableCheckRangePosition;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.TableInventoryCheckCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.yaml.YamlTableDataConsistencyCheckResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.yaml.YamlTableDataConsistencyCheckResultSwapper;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryCheckParameter;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.TableInventoryChecker;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.QueryType;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculateParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.calculator.TableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTaskUtils;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.infra.util.close.QuietlyCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatchingTableInventoryChecker
implements TableInventoryChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MatchingTableInventoryChecker.class);
    private final TableInventoryCheckParameter param;
    private final AtomicBoolean canceling = new AtomicBoolean(false);
    private volatile TableInventoryCalculator<TableInventoryCheckCalculatedResult> sourceCalculator;
    private volatile TableInventoryCalculator<TableInventoryCheckCalculatedResult> targetCalculator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableDataConsistencyCheckResult checkSingleTableInventoryData() {
        ThreadFactory threadFactory = ExecutorThreadFactoryBuilder.build((String)(this.param.getJobId() + "-matching-check-%d"));
        ThreadPoolExecutor executor = new ThreadPoolExecutor(2, 2, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2), threadFactory);
        try {
            TableDataConsistencyCheckResult tableDataConsistencyCheckResult = this.checkSingleTableInventoryData(this.param, executor);
            return tableDataConsistencyCheckResult;
        }
        finally {
            executor.shutdown();
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDataConsistencyCheckResult checkSingleTableInventoryData(TableInventoryCheckParameter param, ThreadPoolExecutor executor) {
        TableInventoryCalculateParameter sourceParam = new TableInventoryCalculateParameter(param.getSourceDataSource(), param.getSourceTable(), param.getColumnNames(), param.getUniqueKeys(), QueryType.RANGE_QUERY, param.getQueryCondition());
        TableCheckRangePosition checkRangePosition = param.getProgressContext().getTableCheckRangePositions().get(param.getSplittingItem());
        sourceParam.setRange(Range.closed(null != checkRangePosition.getSourcePosition() ? checkRangePosition.getSourcePosition() : checkRangePosition.getSourceRange().getLowerBound(), checkRangePosition.getSourceRange().getUpperBound()));
        TableInventoryCalculateParameter targetParam = this.getTableInventoryCalculateParameter(param, checkRangePosition);
        TableInventoryCalculator<TableInventoryCheckCalculatedResult> sourceCalculator = this.buildSingleTableInventoryCalculator();
        this.sourceCalculator = sourceCalculator;
        TableInventoryCalculator<TableInventoryCheckCalculatedResult> targetCalculator = this.buildSingleTableInventoryCalculator();
        this.targetCalculator = targetCalculator;
        try {
            Iterator<TableInventoryCheckCalculatedResult> sourceCalculatedResults = PipelineTaskUtils.waitFuture(executor.submit(() -> sourceCalculator.calculate(sourceParam))).iterator();
            Iterator<TableInventoryCheckCalculatedResult> targetCalculatedResults = PipelineTaskUtils.waitFuture(executor.submit(() -> targetCalculator.calculate(targetParam))).iterator();
            TableDataConsistencyCheckResult tableDataConsistencyCheckResult = this.checkSingleTableInventoryData(sourceCalculatedResults, targetCalculatedResults, param, executor);
            return tableDataConsistencyCheckResult;
        }
        finally {
            QuietlyCloser.close((AutoCloseable)sourceParam.getCalculationContext());
            QuietlyCloser.close((AutoCloseable)targetParam.getCalculationContext());
            this.sourceCalculator = null;
            this.targetCalculator = null;
        }
    }

    private TableDataConsistencyCheckResult checkSingleTableInventoryData(Iterator<TableInventoryCheckCalculatedResult> sourceCalculatedResults, Iterator<TableInventoryCheckCalculatedResult> targetCalculatedResults, TableInventoryCheckParameter param, ThreadPoolExecutor executor) {
        YamlTableDataConsistencyCheckResult checkResult = new YamlTableDataConsistencyCheckResult(true);
        while (sourceCalculatedResults.hasNext() && targetCalculatedResults.hasNext()) {
            if (null != param.getReadRateLimitAlgorithm()) {
                param.getReadRateLimitAlgorithm().intercept(PipelineSQLOperationType.SELECT, 1);
            }
            TableInventoryCheckCalculatedResult sourceCalculatedResult = PipelineTaskUtils.waitFuture(executor.submit(sourceCalculatedResults::next));
            TableInventoryCheckCalculatedResult targetCalculatedResult = PipelineTaskUtils.waitFuture(executor.submit(targetCalculatedResults::next));
            if (!Objects.equals(sourceCalculatedResult, targetCalculatedResult)) {
                checkResult.setMatched(false);
                log.info("content matched false, jobId={}, sourceTable={}, targetTable={}, uniqueKeys={}", new Object[]{param.getJobId(), param.getSourceTable(), param.getTargetTable(), param.getUniqueKeys()});
                break;
            }
            TableCheckRangePosition checkRangePosition = param.getProgressContext().getTableCheckRangePositions().get(param.getSplittingItem());
            if (sourceCalculatedResult.getMaxUniqueKeyValue().isPresent()) {
                checkRangePosition.setSourcePosition(sourceCalculatedResult.getMaxUniqueKeyValue().get());
            }
            if (targetCalculatedResult.getMaxUniqueKeyValue().isPresent()) {
                checkRangePosition.setTargetPosition(targetCalculatedResult.getMaxUniqueKeyValue().get());
            }
            param.getProgressContext().onProgressUpdated(new PipelineJobUpdateProgress(sourceCalculatedResult.getRecordsCount()));
        }
        TableCheckRangePosition checkRangePosition = param.getProgressContext().getTableCheckRangePositions().get(param.getSplittingItem());
        checkRangePosition.setFinished(true);
        if (sourceCalculatedResults.hasNext() || targetCalculatedResults.hasNext()) {
            checkResult.setMatched(false);
        }
        checkRangePosition.setMatched(checkResult.isMatched());
        return new YamlTableDataConsistencyCheckResultSwapper().swapToObject(checkResult);
    }

    private TableInventoryCalculateParameter getTableInventoryCalculateParameter(TableInventoryCheckParameter param, TableCheckRangePosition checkRangePosition) {
        TableInventoryCalculateParameter result = new TableInventoryCalculateParameter(param.getTargetDataSource(), param.getTargetTable(), param.getColumnNames(), param.getUniqueKeys(), QueryType.RANGE_QUERY, param.getQueryCondition());
        result.setRange(Range.closed(null != checkRangePosition.getTargetPosition() ? checkRangePosition.getTargetPosition() : checkRangePosition.getTargetRange().getLowerBound(), checkRangePosition.getTargetRange().getUpperBound()));
        return result;
    }

    protected abstract TableInventoryCalculator<TableInventoryCheckCalculatedResult> buildSingleTableInventoryCalculator();

    @Override
    public void cancel() {
        this.canceling.set(true);
        Optional.ofNullable(this.sourceCalculator).ifPresent(PipelineCancellable::cancel);
        Optional.ofNullable(this.targetCalculator).ifPresent(PipelineCancellable::cancel);
    }

    @Override
    public boolean isCanceling() {
        return this.canceling.get();
    }

    @Generated
    public MatchingTableInventoryChecker(TableInventoryCheckParameter param) {
        this.param = param;
    }

    @Generated
    protected TableInventoryCheckParameter getParam() {
        return this.param;
    }
}

