/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.config.rule.checker.DatabaseRuleConfigurationEmptyChecker;
import org.apache.shardingsphere.infra.config.rule.scope.DatabaseRuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class DatabaseExportMetaDataGenerator {
    private final ShardingSphereDatabase database;

    public String generateYAMLFormat() {
        StringBuilder result = new StringBuilder();
        this.appendDatabaseName(this.database.getName(), result);
        this.appendDataSourceConfigurations(this.database, result);
        this.appendRuleConfigurations(this.database.getRuleMetaData().getConfigurations(), result);
        return result.toString();
    }

    private void appendDatabaseName(String databaseName, StringBuilder stringBuilder) {
        stringBuilder.append("databaseName: ").append(databaseName).append(System.lineSeparator());
    }

    private void appendDataSourceConfigurations(ShardingSphereDatabase database, StringBuilder stringBuilder) {
        if (database.getResourceMetaData().getStorageUnits().isEmpty()) {
            return;
        }
        stringBuilder.append("dataSources:").append(System.lineSeparator());
        for (Map.Entry entry : database.getResourceMetaData().getStorageUnits().entrySet()) {
            this.appendDataSourceConfiguration((String)entry.getKey(), ((StorageUnit)entry.getValue()).getDataSourcePoolProperties(), stringBuilder);
        }
    }

    private void appendDataSourceConfiguration(String dataSourceName, DataSourcePoolProperties props, StringBuilder stringBuilder) {
        String value;
        stringBuilder.append(this.createIndentation(2)).append(dataSourceName).append(':').append(System.lineSeparator());
        for (Map.Entry entry : props.getConnectionPropertySynonyms().getStandardProperties().entrySet()) {
            if (null == entry.getValue()) continue;
            value = entry.getValue().toString();
            stringBuilder.append(this.createIndentation(4)).append((String)entry.getKey()).append(": ").append(value).append(System.lineSeparator());
        }
        for (Map.Entry entry : props.getPoolPropertySynonyms().getStandardProperties().entrySet()) {
            if (null == entry.getValue()) continue;
            value = entry.getValue().toString();
            stringBuilder.append(this.createIndentation(4)).append((String)entry.getKey()).append(": ").append(value).append(System.lineSeparator());
        }
    }

    private void appendRuleConfigurations(Collection<RuleConfiguration> ruleConfigs, StringBuilder stringBuilder) {
        if (ruleConfigs.isEmpty()) {
            return;
        }
        boolean hasAppendedRule = false;
        for (Map.Entry entry : OrderedSPILoader.getServices(YamlRuleConfigurationSwapper.class, ruleConfigs).entrySet()) {
            if (((DatabaseRuleConfigurationEmptyChecker)TypedSPILoader.getService(DatabaseRuleConfigurationEmptyChecker.class, ((RuleConfiguration)entry.getKey()).getClass())).isEmpty((DatabaseRuleConfiguration)entry.getKey())) continue;
            if (!hasAppendedRule) {
                stringBuilder.append("rules:").append(System.lineSeparator());
                hasAppendedRule = true;
            }
            stringBuilder.append(YamlEngine.marshal(Collections.singletonList(((YamlRuleConfigurationSwapper)entry.getValue()).swapToYamlConfiguration(entry.getKey()))));
        }
    }

    private String createIndentation(int count) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(" ");
        }
        return result.toString();
    }

    @Generated
    public DatabaseExportMetaDataGenerator(ShardingSphereDatabase database) {
        this.database = database;
    }
}

