/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.response.header.query;

import java.sql.SQLException;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.Projection;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.ProjectionsContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.syntax.ColumnIndexOutOfRangeException;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeader;
import org.apache.shardingsphere.proxy.backend.response.header.query.QueryHeaderBuilder;

public final class QueryHeaderBuilderEngine {
    private final DatabaseType databaseType;

    public QueryHeader build(QueryResultMetaData queryResultMetaData, ShardingSphereDatabase database, int columnIndex) throws SQLException {
        String columnName = queryResultMetaData.getColumnName(columnIndex);
        String columnLabel = queryResultMetaData.getColumnLabel(columnIndex);
        return ((QueryHeaderBuilder)DatabaseTypedSPILoader.getService(QueryHeaderBuilder.class, (DatabaseType)this.databaseType)).build(queryResultMetaData, database, columnName, columnLabel, columnIndex);
    }

    public QueryHeader build(ProjectionsContext projectionsContext, QueryResultMetaData queryResultMetaData, ShardingSphereDatabase database, int columnIndex) throws SQLException {
        ShardingSpherePreconditions.checkState((columnIndex <= projectionsContext.getExpandProjections().size() ? 1 : 0) != 0, () -> new ColumnIndexOutOfRangeException(columnIndex));
        Projection projection = (Projection)projectionsContext.getExpandProjections().get(columnIndex - 1);
        return ((QueryHeaderBuilder)DatabaseTypedSPILoader.getService(QueryHeaderBuilder.class, (DatabaseType)this.databaseType)).build(queryResultMetaData, database, projection.getColumnName(), projection.getColumnLabel(), columnIndex);
    }

    @Generated
    public QueryHeaderBuilderEngine(DatabaseType databaseType) {
        this.databaseType = databaseType;
    }
}

